/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.util;

import faust.sacha.web.util.WebGlobal;

/** This class handles the options for Metis.
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public final class MetisOpt {

    private static int m_reportType;
    private static String m_rootURL;
    
    public MetisOpt() {
        m_rootURL = "";
        m_reportType = MetisGlobal.REPORT_TYPE_HTML;
        
        // Make sure the globals are init properly
        WebGlobal.setUserAgent( MetisGlobal.METIS_USER_AGENT );
        WebGlobal.initProperties();
        
    }
//------------------------------------------------------------------------------
    /**
     * @param requestMethod The request method type. See <I>faust.sacha.web.uti.WebGlobal</I> for a listing
     * of available request method types.
     */    
    public void setRequestMethod( int requestMethod ){
        WebGlobal.setRequestMethod( requestMethod );
    }
//------------------------------------------------------------------------------
    /**
     * @param debug True will enable debugging.
     * False will disable debugging.
     */    
    public void setDebug( boolean debug ){
        WebGlobal.setDebug( debug );
        MetisGlobal.setDebug( debug );
    }
//------------------------------------------------------------------------------
    /**
     * @param proxyHost The host used for proxying.
     */    
    public void setProxyHost( String proxyHost ){
        WebGlobal.PROXY_HOST = proxyHost;
    }
//------------------------------------------------------------------------------
    /**
     * @param proxyPort The port used by the proxy server.
     */    
    public void setProxyPort( int proxyPort ){
        WebGlobal.PROXY_PORT = proxyPort;
    }
//------------------------------------------------------------------------------    
    /**
     * @param type Report type to generate. See <I>org.ideahamster.util.MetisGlobal</I> for a listing of valid
     * report types.
     */    
    public void setReportType( int type ){
        m_reportType = type;
    }
//------------------------------------------------------------------------------
    /**
     * @return The report type used.
     */    
    public static int getReportType(){
        return m_reportType;
    }
//------------------------------------------------------------------------------
    /**
     * @param username The user name used to authenticate to the server.
     */    
    public void setRequestUserName( String username ){
        WebGlobal.HTTP_USER = username;
    }
//------------------------------------------------------------------------------    
    /**
     * @param password The password used to authenticate to the server.
     */    
    public void setRequestPassword( String password ){
        WebGlobal.HTTP_PASSWORD = password;
    }
//------------------------------------------------------------------------------    
    /**
     * @param url The url used to start the spider.
     */    
    public void setrootURL( String url ){
        String strTmp = url.toLowerCase();
        
        if( (!strTmp.startsWith("http")) && (!strTmp.startsWith("https")) )
            m_rootURL = "http://" + url;
        else
            m_rootURL = url;
    }
//------------------------------------------------------------------------------ 
    /**
     * @return The url used to start the spider.
     */    
    public static String getrootURL(){
        return m_rootURL;
    }
//------------------------------------------------------------------------------ 
    /** This method will validate if the required and optional options are
     * all initialized correctly.
     * @return True : all options were set correctly.
     * False : one of the options was not initiated correctly.
     */    
    public boolean validateOptions(){
        
        if( m_rootURL == "" ){
            System.err.println("You need to specify a site!");
            return false;
        }
        
        switch( m_reportType ){
            case MetisGlobal.REPORT_TYPE_ASCII:
            case MetisGlobal.REPORT_TYPE_HTML:
                break;
                
            default:
                System.err.println("Unknown report type : " + m_reportType );
                return false;
        }
        
        if( (WebGlobal.PROXY_PORT <= 0) || (WebGlobal.PROXY_PORT > 6535) ){
            System.err.println("Invalid proxy port specified : " + WebGlobal.PROXY_PORT );
            return false;
        }
        
        return true;
    }
//------------------------------------------------------------------------------
    /** Prints the usage for Metis.
     */    
    public static void usage(){

        System.out.println(MetisGlobal.METIS_USER_AGENT + " by " + MetisGlobal.METIS_AUTHOR + " : " + MetisGlobal.METIS_AUTHOR_EMAIL );
        System.out.println("Usage : ");
        
        System.out.println("\t-h [site name]");
        System.out.println("\t\tExample of valid site name:");
        System.out.println("\t\t\thttp://site.com");
        System.out.println("\t\t\thttps://site.com");
        System.out.println("\t\t\thttps://site.com:port");        
        System.out.println("\t\t\tsite.com");
        System.out.println("\t\t\thttp://site.com/startfolder");
        
        System.out.println("\t-D : enables debug mode");
        //System.out.println("\t-R : allow redirect.");
        //System.out.println("\t-S : allow strict redirect. Will only follow redirect to same domain");
        /*
        System.out.println("\t-r [request method] : Default is GET");
        System.out.println("\t\trequest methods:");
        System.out.println("\t\t\t" + WebGlobal.REQUEST_METHOD_GET + " : GET" );
        System.out.println("\t\t\t" + WebGlobal.REQUEST_METHOD_HEAD + " : HEAD" );
        System.out.println("\t\t\t" + WebGlobal.REQUEST_METHOD_POST + " : POST" );
        System.out.println("\t\t\t" + WebGlobal.REQUEST_METHOD_DELETE + " : DELETE" );
        */
        System.out.println("\t-U [site username]");
        System.out.println("\t-P [site password]");
        
        System.out.println("\t-X [proxy host]");
        System.out.println("\t-C [proxy port]");
        System.out.println("\t-T [report type] : Default is HTML");
        System.out.println("\t\treport types:");
        System.out.println("\t\t\t" + MetisGlobal.REPORT_TYPE_ASCII + " : ASCII");
        System.out.println("\t\t\t" + MetisGlobal.REPORT_TYPE_HTML + " : HTML");
        
        
        System.exit(1);
    }
//------------------------------------------------------------------------------
    public void DEBUG_DUMP_OPTIONS(){
        //System.out.println("requestUsername : " + m_requestUserName);
        //System.out.println("requestPassword : " + m_requestPassword);
        System.out.println("m_rootURL : " + m_rootURL);
        System.out.println("m_reportType : " + m_reportType);
        //System.out.println("config name : " + m_configFileName);
    }
//------------------------------------------------------------------------------    
}
