/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.util;

/** This class contains the global data used by various class.
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public final class MetisGlobal {
    
    public static final String METIS_CR                     = "\r\n";
    public static final String METIS_VERSION                = "1.3";
    public static final String METIS_USER_AGENT             = "metis 1.3";
    public static final String METIS_AUTHOR                 = "Sacha Faust";
    public static final String METIS_AUTHOR_EMAIL           = "sacha@severus.org";
    public static boolean METIS_DEBUG                       = false;
    
    // For Report section
    public static final int REPORT_TYPE_ASCII         = 1;
    public static final int REPORT_TYPE_HTML          = 2;
    
    
    public MetisGlobal() {
    }
//------------------------------------------------------------------------------
    public static void setDebug( boolean debug ){
        METIS_DEBUG = debug;
    }
//------------------------------------------------------------------------------

    
    
}
