/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.util;

import faust.sacha.web.bot.spider.event.*;
import faust.sacha.web.bot.spider.util.EnginGlobal;
import faust.sacha.web.util.*;
import java.io.*;

/** The class used to managed the keyboard input during a spider.
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public class KeyboardProcessor extends ThreadEventManager {
    
    private InputStreamReader m_input;
    private ThreadEventManager m_mainListenner;
    private static final char STOP_KEY = 's';
    private static final char PAUSE_KEY = 'p';
    private static final char NBTHREADS_KEY = 't';
    
    /**
     * @param in The key pressed by the user.
     * @param mainListenner The ThreadEventManager class that wish to receive events based on the input.
     */    
    public KeyboardProcessor( InputStream in, ThreadEventManager mainListenner ) {
        super("KeyboardProcessor");
        m_input = new InputStreamReader(in);
        m_mainListenner = mainListenner;
    }
//------------------------------------------------------------------------------
    /**
     */    
    public void run(){
        
        process();
    }
//------------------------------------------------------------------------------
    private synchronized void process(){
        int state = 0;
        char input;
        ThreadEvent event = null;
               
        main_loop:
        while( true ){
            state = getState();
            
            if( state == ThreadEvent.EVENT_STOP )
                break;
            
            /*
             *  Test if the input is ready, if not, we wait a bit
             *  else, we read the input and evaluate it with the stop key
             */
            try{
                if( m_input.ready() ){
                    input = (char)m_input.read();
                    
                    switch( input ){
                        case STOP_KEY:
                            if( WebGlobal.DEBUG )
                                System.err.println( getName() + "::process() : received STOP_KEY" );
                            
                            System.out.println( "Stopping " + EnginGlobal.THREAD_MANAGER.getNbThreads() + " threads!" );
                            System.out.println( "Please wait" );
                            event = new ThreadEvent(this, null, ThreadEvent.EVENT_STOP);
                            sendEvent(event, m_mainListenner);
                            /*
                             *  Jump out of the while()
                             */
                            break main_loop;
                        case PAUSE_KEY:
                            // Pause is not implemented yet
                            
                            /*
                            if( WebGlobal.DEBUG )
                                System.err.println( getName() + "::process() : received PAUSE_KEY" );
                            
                            event = new ThreadEvent(this, null, ThreadEvent.EVENT_PAUSE);
                            sendEventAll(event);
                            
                            //Jump out of the while()                            
                            break main_loop;
                             */
                        case NBTHREADS_KEY:
                            if( WebGlobal.DEBUG )
                                System.err.println( getName() + "::process() : receive NBTHREADS_KEY" );
                            
                            System.out.println( "Current number of threads : " + EnginGlobal.THREAD_MANAGER.getNbThreads() );
                            break;
                        default:
                            if( WebGlobal.DEBUG )
                                System.err.println( getName() + "::process : received unreleated key : " + input );
                            break;
                    }
                }
                else{
                    /*
                     *  Release the lock and wait a bit
                     */
                    try{
                        wait(500);
                    }
                    catch( InterruptedException intEx ){
                        if( WebGlobal.DEBUG )
                            System.err.println( getName() + "::process() : " + intEx );
                    }
                }
            }
            catch( IOException ioEx ){
                System.err.println( getName() + "::process() : " + ioEx );
                continue;
            }
        }
    }
//------------------------------------------------------------------------------
    /*
    public static void main( String args[] ){
        KeyboardProcessor p = null;
        
        WebGlobal.setDebug(true);
        p = new KeyboardProcessor("KeyboardProcessor", System.in);
        p.start();
    }
     */
    
}
