/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.stat;

import faust.sacha.web.data.*;
import java.util.*;

/**
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public class SiteStats {

    private Site m_site;
    private int m_nbTotalFiles;
    private int m_nbTotalFolders;
    private int m_nbTotalEmails;
    private int m_nbTotalOutsideURLs;
    private long m_nbTotalObjectSize;
    private FileExtensionStat m_fileExtStats;
    private FolderStat m_folderStats;
    private EmailByDomainStat m_emailByDomainStats;
    private OutsideURLByDomainStat m_outsideURLByDomainStats;
    private SiteScripts m_siteScripts;
    private String m_siteServerString;
    
    private SiteStats(){
        m_nbTotalFiles = 0;
        m_nbTotalFolders = 0;
        m_nbTotalEmails = 0;
        m_nbTotalOutsideURLs = 0;
        m_nbTotalObjectSize = 0;
        m_siteServerString = "";
    }
    
    public SiteStats( Site site ) {
        this();
        m_site = site;
        
        setTotalElements();
        setStats();
    }
//------------------------------------------------------------------------------
    private void setStats(){
        setFileExtensionStats();
        setFolderStats();
        setEmailsByDomainStats();
        setOutisdeURLsStats();
        setTotalObjectSize();
        setSiteScripts();
        setSiteServerString();
        
    }
//------------------------------------------------------------------------------
    private void setTotalElements(){
        setTotalFilesAndFolders();
        setTotalEmails();
        setTotalOutsideURLs();
    }
//------------------------------------------------------------------------------
    private void setTotalFilesAndFolders(){
        Hashtable folderHash = m_site.getFolderHashTable();
        Enumeration folderKeys = folderHash.keys();
        String key = null;
        ArrayList fileList = null;
        
        while( folderKeys.hasMoreElements() ){
            key = (String)folderKeys.nextElement();
            fileList = (ArrayList)folderHash.get(key);
            
            m_nbTotalFolders++;
            m_nbTotalFiles += fileList.size();
        }
    }
//------------------------------------------------------------------------------
    private void setTotalEmails(){
        m_nbTotalEmails = ( m_site.getEmailsFound() ).size();
    }
//------------------------------------------------------------------------------    
    private void setTotalOutsideURLs(){
        m_nbTotalOutsideURLs = m_site.getOutsideURLs().size();
    }
//------------------------------------------------------------------------------
    private void setFileExtensionStats(){
        m_fileExtStats = new FileExtensionStat(m_site, m_nbTotalFiles);
    }
//------------------------------------------------------------------------------    
    private void setFolderStats(){
        m_folderStats = new FolderStat(m_site, m_nbTotalFiles);
    }
//------------------------------------------------------------------------------    
    private void setEmailsByDomainStats(){
        m_emailByDomainStats = new EmailByDomainStat(m_site, m_nbTotalEmails);
    }
//------------------------------------------------------------------------------
    private void setOutisdeURLsStats(){
        m_outsideURLByDomainStats = new OutsideURLByDomainStat(m_site, m_nbTotalOutsideURLs);
    }
//------------------------------------------------------------------------------
    private void setTotalObjectSize(){
        Enumeration folderKeys = m_site.getFoldersNames();
        String key = null;
        ArrayList fileList = null;
        FileURL file = null;
        ArrayList queryList = null;
        ScriptStateInfo queryData = null;
        
        while( folderKeys.hasMoreElements() ){
            key = (String)folderKeys.nextElement();
            fileList = (ArrayList)m_site.getFolderElements(key);
            
            for( int i = 0; i < fileList.size(); i++ ){
                file = (FileURL)fileList.get(i);
                if( file.isScript() ){
                    queryList = file.getQueryDataList();
                    for( int queryIndex = 0; queryIndex < queryList.size(); queryIndex++ ){
                        queryData = (ScriptStateInfo)queryList.get(queryIndex);
                        m_nbTotalObjectSize += queryData.getContentLengthInfo();
                    }
                }
                else
                    m_nbTotalObjectSize += file.getContentLengthInfo();
            }
        }
    }
//------------------------------------------------------------------------------
    private void setSiteScripts(){
        m_siteScripts = new SiteScripts(m_site);
    }
//------------------------------------------------------------------------------
    private void setSiteServerString(){
        Enumeration folderKeys = m_site.getFoldersNames();
        String key = null;
        ArrayList fileList = null;
        FileURL file = null;
        ArrayList queryList = null;
        ScriptStateInfo queryData = null;
        
        while( folderKeys.hasMoreElements() ){
            key = (String)folderKeys.nextElement();
            fileList = (ArrayList)m_site.getFolderElements(key);
                       
            for( int i = 0; i < fileList.size(); i++ ){
                file = (FileURL)fileList.get(i);
                m_siteServerString = file.getHeaderContent("server", 0);
                if( (m_siteServerString != null) && !(m_siteServerString.equals("")) )
                    break;
            }
        }       
    }
//------------------------------------------------------------------------------
    public FileExtensionStat getFileExtensionStats(){
        return m_fileExtStats;
    }
//------------------------------------------------------------------------------
    public FolderStat getFolderStats(){
        return m_folderStats;
    }
//------------------------------------------------------------------------------    
    public int getNumberOfFiles(){
        return m_nbTotalFiles;
    }
//------------------------------------------------------------------------------
    public int getNumberOfFolders(){
        return m_nbTotalFolders;
    }
//------------------------------------------------------------------------------
    public int getNumberOfEmails(){
        return m_nbTotalEmails;
    }
//------------------------------------------------------------------------------
    public EmailByDomainStat getEmailByDomainStats(){
        return m_emailByDomainStats;
    }
//------------------------------------------------------------------------------
    public OutsideURLByDomainStat getOutsideURLByDomainStats(){
        return m_outsideURLByDomainStats;
    }
//------------------------------------------------------------------------------
    public long getTotalObjectSize(){
        return m_nbTotalObjectSize;
    }
//------------------------------------------------------------------------------
    public SiteScripts getSiteScripts(){
        return m_siteScripts;
    }
//------------------------------------------------------------------------------
    public String getSiteServerType(){
        return m_siteServerString;
    }
    
}
