/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.stat;

import faust.sacha.web.data.*;
import java.util.*;

/**
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public class SiteScripts {

    private Site m_site;
    private ArrayList m_scriptsList;
    
    private SiteScripts(){
        m_scriptsList = new ArrayList(0);
    }
    public SiteScripts( Site site ) {
        this();
        m_site = site;
        
        init();
    }
//------------------------------------------------------------------------------
    private void init(){
        Enumeration folderKeys = m_site.getFoldersNames();
        String key = null;
        ArrayList fileList = null;
        FileURL file = null;
        
        while( folderKeys.hasMoreElements() ){
            key = (String)folderKeys.nextElement();
            fileList = m_site.getFolderElements(key);
            
            for( int i = 0; i < fileList.size(); i++ ){
                file = (FileURL)fileList.get(i);
                if( file.isScript() )
                    addScript(file);
            }
        }
    }
//------------------------------------------------------------------------------
    private void addScript( FileURL script ){
        m_scriptsList.add( (Object)script );
    }
//------------------------------------------------------------------------------
    public ArrayList getScripts(){
        return m_scriptsList;
    }
//------------------------------------------------------------------------------    

}
