/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.stat;

import faust.sacha.web.data.Site;
import java.util.*;

/**
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public abstract class SiteElementStat {
    
    protected Site m_site;
    protected int m_nbTotalElements;
    protected Hashtable m_dataHash;
    
    private SiteElementStat(){
        m_site = null;
        m_nbTotalElements = 0;
        m_dataHash = new Hashtable(0);
    }
    
    public SiteElementStat( Site site, int nbElements ){
        this();
        m_site = site;
        m_nbTotalElements = nbElements;
        
        init();
    }
//------------------------------------------------------------------------------
    protected abstract void init();
//------------------------------------------------------------------------------
    public Enumeration getDataKeys(){
        return m_dataHash.keys();
    }
//------------------------------------------------------------------------------
    public ElementStat getElement( String key ){
        return (ElementStat)m_dataHash.get( (Object)key );
    }
//------------------------------------------------------------------------------
    
}

