/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.stat;

import faust.sacha.web.data.*;
import faust.sacha.web.util.*;
import org.ideahamster.metis.util.*;
import java.util.*;

/**
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public class OutsideURLByDomainStat extends SiteElementStat {
    
    public OutsideURLByDomainStat( Site site, int nbTotalElements) {
        super(site, nbTotalElements);
    }
//------------------------------------------------------------------------------
    protected void init() {
        ArrayList outsideURLs = m_site.getOutsideURLs();
        URLInfo outsideURL = null;
        
        for( int i = 0; i < outsideURLs.size(); i++ ){
            outsideURL = (URLInfo)outsideURLs.get(i);
            processOutsideURL( outsideURL );
        }
    }
//------------------------------------------------------------------------------
    private void processOutsideURL( URLInfo outsideURL) {
        String domain = outsideURL.getHost().toLowerCase(); //only deal with lower name
        ElementStat element = null;
        
        /*
         * we try to add the domain
         * if it's already there, nothing is done
         * see addDomain(String )
         */
        addDomain(domain);
        
        element = getElement(domain);
        element.addElement( (Object)outsideURL );
    }
//------------------------------------------------------------------------------
    private void addDomain( String domain ){
        if( !m_dataHash.containsKey((Object)domain) ){
            m_dataHash.put( (Object)domain, new ElementStat(domain, m_nbTotalElements) );
            if( MetisGlobal.METIS_DEBUG )
                System.err.println("OutsideURLByDomainStat::addDomain : added domain : " + domain);
        }
        else{
            if( MetisGlobal.METIS_DEBUG )
                System.err.println("OutsideURLByDomainStat::addDomain : duplicate domain : " + domain);
        }
    }
//------------------------------------------------------------------------------

}
