/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.stat;

import faust.sacha.web.data.*;
import java.util.*;

/**
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public class FolderStat extends SiteElementStat{

    public FolderStat( Site site, int nbTotalElements ) {
        super(site, nbTotalElements );
    }
    
//------------------------------------------------------------------------------
    protected void init(){
        Hashtable siteFolders = m_site.getFolderHashTable();
        Enumeration siteFolderKeys = siteFolders.keys();
        String folderKey = null;
        ArrayList fileList = null;
        FileURL fileInfo = null;
        
        while( siteFolderKeys.hasMoreElements() ){
            folderKey = (String)siteFolderKeys.nextElement();
            ElementStat stat = new ElementStat( folderKey, m_nbTotalElements );
            //ElementStat stat = new ElementStat( folderKey, new ElementStat(folderKey, m_m_nbTotalElements) );
            m_dataHash.put( (Object)folderKey, (Object)stat );
            
            fileList = (ArrayList)siteFolders.get( (Object)folderKey );
            
            for( int i = 0; i < fileList.size(); i++ ){
                fileInfo = (FileURL)fileList.get(i);
                stat.addElement( (Object)fileInfo );
            }
        }
    }
//------------------------------------------------------------------------------ 

}
