/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.stat;

import faust.sacha.web.data.*;
import org.ideahamster.metis.util.*;
import java.util.*;

/**
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public class FileExtensionStat extends SiteElementStat {
   
    public FileExtensionStat( Site site, int nbTotalFiles ){
        super(site, nbTotalFiles);
    }
//------------------------------------------------------------------------------
    protected void init() {
        Enumeration folderKeys = m_site.getFoldersNames();
        String folderName = null;
        ArrayList fileList = null;
        FileURL file = null;
        
        while( folderKeys.hasMoreElements() ){
            folderName = (String)folderKeys.nextElement();
            fileList = m_site.getFolderElements(folderName);
            
            for( int i = 0; i < fileList.size(); i++ ){
                file = (FileURL)fileList.get(i);
                processFile(file);
            }
        }
    }
//------------------------------------------------------------------------------
    private void processFile( FileURL file ){
        
        /*
         * Logic
         *  we just add the element. If the key already exist
         *  addExtensionKey wont overwrite it
         */
        addExtensionKey( file.getExtension().toLowerCase() );
        addFileToExtensionStat( file );
        
    }
//------------------------------------------------------------------------------
    private void addExtensionKey( String extension ){
        if( !m_dataHash.containsKey(extension) ){
            m_dataHash.put( (Object)extension , new ElementStat( extension, m_nbTotalElements) );
            if( MetisGlobal.METIS_DEBUG )
                System.err.println("FileExtensionStat::addExtensionKey : added key : " + extension );
        }
        else{
            if( MetisGlobal.METIS_DEBUG )
                System.err.println("FileExtensionStat::addExntensionKey : duplicate key : " + extension );
        }
    }
//------------------------------------------------------------------------------
    private void addFileToExtensionStat( FileURL file ){
        ElementStat extensionStat = getElement( file.getExtension().toLowerCase() );
     
        if( extensionStat != null )
            extensionStat.addElement( (FileURL)file );
        else{
            if( MetisGlobal.METIS_DEBUG )
                System.err.println("FileExtensionStat::addFileToExtensionStat : null elementstat for : " + file.getExtension().toLowerCase() );
        }
    }
//------------------------------------------------------------------------------    
    
}
