/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.stat;

import faust.sacha.web.data.*;
import org.ideahamster.metis.util.*;
import java.util.*;

/**
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public class EmailByDomainStat extends SiteElementStat {

    public EmailByDomainStat(Site site, int nbTotalEmails) {
        super(site, nbTotalEmails);
    }
//------------------------------------------------------------------------------
    protected void init(){
        ArrayList siteEmails = m_site.getEmailsFound();
        EmailURL emailData = null;
        
        for( int i = 0; i < siteEmails.size(); i++ ){
            emailData = (EmailURL)siteEmails.get(i);
            processEmailURL(emailData); 
        }
    }
//------------------------------------------------------------------------------
    private void processEmailURL( EmailURL email ){
        String domain = email.getDomain().toLowerCase();
        ElementStat element = null;

        if( domain.equals("") || (domain == null) ){
            System.err.println("EmailByDomain::processEmailURL : null or empty domain for : " + email.toString() );
            return;
        }
        /*
         * we try to add the domain
         * if it's already there, nothing is done
         * see addDomain(String )
         */
        addDomain(domain);

        element = getElement(domain);
        element.addElement( (Object)email );
    }
//------------------------------------------------------------------------------    
    private void addDomain( String domain ){
        
        if( !m_dataHash.containsKey((Object)domain) ){
            m_dataHash.put( (Object)domain, (Object)new ElementStat(domain, m_nbTotalElements) );
            if( MetisGlobal.METIS_DEBUG )
                System.err.println("EmailByDomain::addDomain : added domain : " + domain);
        }
        else{
            if( MetisGlobal.METIS_DEBUG )
                System.err.println("EmailByDomain::addDomain : duplicate domain : " + domain);
        }
    }
//------------------------------------------------------------------------------
    
}
