/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.stat;

import java.util.*;

/**
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public class ElementStat {

    protected int m_nbElements;
    protected int m_nbTotalElements;
    protected String m_elementName;
    private ArrayList m_memberList;
    
    private ElementStat(){
        m_nbElements = 0;
        m_nbTotalElements = 0;
        m_elementName = "";
        m_memberList = new ArrayList(0);
    }
    
    public ElementStat( String name, int nbTotalElements ){
        this();
        m_elementName = name;
        m_nbTotalElements = nbTotalElements;
    }
    
    public ElementStat( String name, int nbTotalElements, int nbElements ){
        this(name, nbTotalElements);
        m_nbElements = nbElements;
    }
//------------------------------------------------------------------------------
    public void setName( String name ){
        m_elementName = name;
    }
//------------------------------------------------------------------------------
    public void setNbElements( int nbTotalElements ){
        m_nbTotalElements = nbTotalElements;
    }
//------------------------------------------------------------------------------    
    public String getName(){
        return m_elementName;
    }
//------------------------------------------------------------------------------
    public int getNumberOfElements(){
        return m_nbElements;
    }
//------------------------------------------------------------------------------
    public double getPercentage(){
        return (double) ( (m_nbElements / (double)m_nbTotalElements) * 100 );
    }
//------------------------------------------------------------------------------
    public int getDifference(){
        return (m_nbTotalElements - m_nbElements);
    }
//------------------------------------------------------------------------------
    public void addElement( Object memberName ){
        m_memberList.add( memberName );
        m_nbElements++;
    }
//------------------------------------------------------------------------------    
    public ArrayList getMembers(){
        return m_memberList;
    }
//------------------------------------------------------------------------------    
    

}
