/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.report;

import faust.sacha.web.data.*;
import faust.sacha.web.util.*;
import org.ideahamster.metis.stat.*;
import org.ideahamster.metis.util.*;
import java.io.*;
import java.util.*;

/**
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public class MetisReportASCII extends MetisReport {

    public MetisReportASCII( Site site, SiteStats siteStats, String fileName ) {
        super( site, siteStats, fileName + ".txt" );
    }
//------------------------------------------------------------------------------    
    protected String generateHeaderReport() {
        StringWriter reportHeader = new StringWriter();
        double totalSiteSize = 0;
        String totalSiteSizeStr = null;
        int dotPos = 0;

        

        reportHeader.write( "Metis report for : " + m_site.getDomain() + "\n" );
        reportHeader.write("Server type : " + m_siteStats.getSiteServerType() + "\n");
        reportHeader.write( "Date : " + new Date().toString() + "\n" );
        reportHeader.write( "\n" );
            
        reportHeader.write( "Total Number of Files : " + m_siteStats.getNumberOfFiles() + "\n" );
        reportHeader.write( "Total Number of Folders : " + m_siteStats.getNumberOfFolders() + "\n" );
        reportHeader.write( "Total Number of Emails : " + m_siteStats.getNumberOfEmails() + "\n" );

        try{
            totalSiteSize = (double)m_siteStats.getTotalObjectSize();
            totalSiteSizeStr = String.valueOf( totalSiteSize / (double)1048576 );
            dotPos = totalSiteSizeStr.indexOf(".");
            if( dotPos != -1 ){
                if( (totalSiteSizeStr.length() - dotPos) > 2 )
                    totalSiteSizeStr = totalSiteSizeStr.substring(0, dotPos + 2);
            }
            reportHeader.write( "Site size estimate : " + totalSiteSizeStr + " MB" + "\n" );
        }
        catch( NumberFormatException numEx ){
            if( WebGlobal.DEBUG )
                System.err.println( "MetisReportASCII::generateHeaderReport() : " + numEx );
            
            
            reportHeader.write("Site size estimate : " + m_siteStats.getTotalObjectSize() + " Bytes" + "\n" );
        }     
            
        reportHeader.write( "---------------------------------\n");
        return reportHeader.toString();
    }    
//------------------------------------------------------------------------------
    protected String generateFileByTypeReport(){
        StringWriter reportBuff = new StringWriter();
        FileExtensionStat fileExStats = m_siteStats.getFileExtensionStats();
        Enumeration keys = fileExStats.getDataKeys();
        String fileExKey = null;
        ElementStat elementData = null;
        ArrayList fileList = null;
        FileURL file = null;
        
        
        reportBuff.write( "[Files by type]\n\n" );

        
        while( keys.hasMoreElements() ){
            fileExKey = (String)keys.nextElement();
            elementData = (ElementStat)fileExStats.getElement( fileExKey );
            fileList = elementData.getMembers();
            
            reportBuff.write( "Extension : " + elementData.getName() + "\n" );
            reportBuff.write( "Number of files : " + elementData.getNumberOfElements() + "\n" );
            reportBuff.write( "% on total : " + Double.toString(elementData.getPercentage()) + "%\n" );
            reportBuff.write( "File List : \n" );
            
            for( int i = 0; i < fileList.size(); i++ ){
                file = (FileURL)fileList.get(i);
                reportBuff.write( "\t" + file.getPath() + "\n" );
            }

            reportBuff.write( "\n" );
        }
        
        reportBuff.write( "---------------------------------\n");
        return reportBuff.toString();
    }
//------------------------------------------------------------------------------    
    protected String generateFolderReport(){
        StringWriter reportBuff = new StringWriter();
        FolderStat folderStat = m_siteStats.getFolderStats();
        Enumeration folderKeys = folderStat.getDataKeys();
        String key = null;
        ElementStat elementData = null;
        

        reportBuff.write( "[Folders]\n\n");
        
        while( folderKeys.hasMoreElements() ){
            key = (String)folderKeys.nextElement();
            
            elementData = folderStat.getElement(key);
            
            reportBuff.write( "FolderName : " + key + "\n" );
            reportBuff.write( "Number of files : " + elementData.getNumberOfElements() + "\n" );
            reportBuff.write( "% on total : " + Double.toString(elementData.getPercentage()) + "%\n" );
                
            reportBuff.write( "\n" );
        }
        
        reportBuff.write( "---------------------------------\n");
        return reportBuff.toString();
    }
//------------------------------------------------------------------------------    
    protected String generateEmailByDomainReport(){
        StringWriter reportBuff = new StringWriter();
        EmailByDomainStat emailStat = m_siteStats.getEmailByDomainStats();
        Enumeration domainsKeys = emailStat.getDataKeys();
        String domain = null;
        ElementStat elementData = null;
        ArrayList elementArray = null;
        EmailURL email = null;
        
        reportBuff.write("[Emails found by domain]\n\n");
     
        while( domainsKeys.hasMoreElements() ){
            domain = (String)domainsKeys.nextElement();
        
            elementData = emailStat.getElement(domain);
        
            reportBuff.write( "Domain : " + domain + "\n" );
        
            elementArray = elementData.getMembers();
            for( int i = 0; i < elementArray.size(); i++ ){
                email = (EmailURL)elementArray.get(i);
                reportBuff.write( "\tEmail : " + email.getEmail() + "\n" );
                reportBuff.write( "\tSubject : " + email.getSubject() + "\n" );
                reportBuff.write( "\tOther arguments : " + email.getArgumentData() + "\n" );
            
                reportBuff.write( "\n" );
            }
        
            reportBuff.write( "\n" );
        }
     
         reportBuff.write( "---------------------------------\n");
         return reportBuff.toString();
    }
//------------------------------------------------------------------------------    
    protected String generateSiteMapReport(){
        StringWriter reportBuff = new StringWriter();
        Enumeration folderKeys = m_site.getFoldersNames();
        String folderName = null;
        ArrayList fileArray = null;
        FileURL file = null;
        ArrayList queryList = null;
        ScriptStateInfo queryData = null;
        
        reportBuff.write( "[Site Map]\n\n" );
        reportBuff.write( m_site.getSiteURL() + "\n" );
     
        while( folderKeys.hasMoreElements() ){
            folderName = (String)folderKeys.nextElement();
            fileArray = m_site.getFolderElements(folderName);
        
            //folder
            reportBuff.write( "\t" + m_site.getSiteURL() + folderName + "\n" );
        
            //files
            for( int i = 0; i < fileArray.size(); i++ ){
                file = (FileURL)fileArray.get(i);
                queryList = file.getQueryDataList();
                reportBuff.write( "\t\t" + file.toString() + "\n" );
                for( int queryIndex = 0; queryIndex < queryList.size(); queryIndex++ ){
                    queryData = (ScriptStateInfo)queryList.get(queryIndex);
                    reportBuff.write("\t\t\t" + queryData.getURL() + "\n");
                }
            }
        
            reportBuff.write( "\n" );
         
        }
        
        reportBuff.write( "---------------------------------\n");
        return reportBuff.toString();       
    }
//------------------------------------------------------------------------------
    protected String generateFileInfoReportByFolder(){
        StringWriter reportBuff = new StringWriter();
        FolderStat folderStat = m_siteStats.getFolderStats();
        Enumeration folderKeys = folderStat.getDataKeys();
        String key = null;
        ElementStat elementData = null;
        ArrayList fileList = null;
        FileURL file = null;
        ArrayList queryList = null;
        ScriptStateInfo queryData = null;
        

        reportBuff.write( "[File Info by Folders]\n\n");
        
        while( folderKeys.hasMoreElements() ){
            key = (String)folderKeys.nextElement();
            elementData = folderStat.getElement(key);
            
        
            reportBuff.write( "FolderName : " + key + "\n" );
            fileList = elementData.getMembers();
                
            for( int i = 0; i < fileList.size(); i++ ){
                file = (FileURL)fileList.get(i);
                
                //reportBuff.write( "\tFilename : " + file.getFileName() + file.getQuery() + "\n" );
                reportBuff.write( "\tFilename : " + file.getFileName() + "\n" );
                if( file.isScript() ){
                    queryList = file.getQueryDataList();
                    reportBuff.write("\tQueries : " + "\n" );
                    
                    for( int queryIndex = 0; queryIndex < queryList.size(); queryIndex++ ){
                        queryData = (ScriptStateInfo)queryList.get(queryIndex);
                        
                        if( queryData.getLastModifiedInfo() != "" )
                            reportBuff.write( "\t\tLast modified data : " + queryData.getLastModifiedInfo() + "\n" );
                        if( queryData.getContentLengthInfoAsString() != "" )
                            reportBuff.write( "\t\tSize : " + queryData.getContentLengthInfoAsString() + "\n" );                        
                    }
                }
                else{
                    if( file.getLastModifiedInfo() != "" )
                        reportBuff.write( "\t\tLast modified data : " + file.getLastModifiedInfo() + "\n" );
                    if( file.getContentLengthInfoAsString() != "" )
                        reportBuff.write( "\t\tSize : " + file.getContentLengthInfoAsString() + "\n" );
                }
                reportBuff.write( "\n" );
            }
            reportBuff.write( "\n" );
        }
        
        reportBuff.write( "---------------------------------\n");
        return reportBuff.toString();
    }
//------------------------------------------------------------------------------  
    protected String generateScriptReport() {
        StringWriter reportBuff = new StringWriter();
        SiteScripts siteScripts = m_siteStats.getSiteScripts();
        ArrayList scriptList = siteScripts.getScripts();
        FileURL script = null;
        Enumeration varNames = null;
        String varKey = null;
        ArrayList dataList = null;
        String data = null;
        
        reportBuff.write( "[Site scripts]\n\n" );
        
        for( int scriptIndex = 0; scriptIndex < scriptList.size(); scriptIndex++ ){
            script = (FileURL)scriptList.get(scriptIndex);
            varNames = script.getArgumentVarNames();
            
            //show the script in folder/script format
            reportBuff.write( script.getFolder() + script.getFileName() + "\n" );
            
            while( varNames.hasMoreElements() ){
                varKey = (String) varNames.nextElement();
                dataList = script.getArgumentVarDataList(varKey);
                
                reportBuff.write("\tVar : " + varKey + "\n");
                for( int dataIndex = 0; dataIndex < dataList.size(); dataIndex++ ){
                    data = (String)dataList.get(dataIndex);
                    if( data != "" )
                        reportBuff.write("\t\t" + data + "\n");
                }
            }
            
            reportBuff.write("\n");
        }

        reportBuff.write( "---------------------------------\n");
        return reportBuff.toString();        
    }
//------------------------------------------------------------------------------    
    protected String generateOutsideURLByDomainReport(){
        StringWriter reportBuff = new StringWriter();
        OutsideURLByDomainStat urlStat = m_siteStats.getOutsideURLByDomainStats();
        Enumeration domainKeys = urlStat.getDataKeys();
        String key = null;
        ElementStat elementData = null;
        ArrayList urlList = null;
        URLInfo url = null;
        
        reportBuff.write( "[Outside urls by Domain]\n\n" );
        
        while( domainKeys.hasMoreElements() ){
            key = (String)domainKeys.nextElement();
            elementData = urlStat.getElement(key);
            
            reportBuff.write( "Domain : " + key + "\n" );
            urlList = elementData.getMembers();
            
            for(int i = 0; i < urlList.size(); i++ ){
                url = (URLInfo)urlList.get(i);
                reportBuff.write( "\t" + url.toString() + "\n" );
            }
            
            reportBuff.write("\n");
        }
        
        reportBuff.write( "---------------------------------\n");
        return reportBuff.toString();     
    }
//------------------------------------------------------------------------------
    protected String generateFootNote(){
        return new String( "This report was generated by " + MetisGlobal.METIS_USER_AGENT + " written by " + MetisGlobal.METIS_AUTHOR + " : " + MetisGlobal.METIS_AUTHOR_EMAIL + "\n" );
    }
//------------------------------------------------------------------------------    
    protected String generateCommentsByFileReport() {
        StringWriter reportBuff = new StringWriter();
        Enumeration folderKeys = m_site.getFoldersNames();
        String key = null;
        ArrayList fileList = null;
        FileURL file = null;
        ArrayList commentList = null;
        ArrayList queryList = null;
        String query = null;
        ScriptStateInfo queryData = null;
        String comment = null;
        
        while( folderKeys.hasMoreElements() ){
            key = (String)folderKeys.nextElement();
            fileList = m_site.getFolderElements(key);
            for( int fileIndex = 0; fileIndex < fileList.size(); fileIndex++ ){
                file = (FileURL)fileList.get(fileIndex);
                
                if( !file.isScript() ){
                    commentList = file.getComments();
                    if( commentList.size() == 0 )
                        continue;
                }
                
                reportBuff.write( "File name : " + file.getFolder() + file.getFileName() + "\n" );
                
                if( !file.isScript() )
                    reportBuff.write("Comments: " + "\n");
                else{
                    queryList = file.getQueryDataList();
                    
                    for(int queryIndex = 0; queryIndex < queryList.size(); queryIndex++ ){
                        queryData = (ScriptStateInfo)queryList.get(queryIndex);
                        
                        
                        if( queryData == null ){
                            System.err.println("MetisReportASCII::generateCommentByFileReport() : queryData is null");
                            continue;
                        }
                        
                        if( (query = queryData.getQuery()) == "" ){
                            System.err.println("MetisReportASCII::generateCommentByFileReport() : query is empty on : " + queryData.getURL() );
                            continue;
                        }
                        
                        reportBuff.write( "\tQuery : " + query + "\n" );
                        reportBuff.write( "\tComments:" + "\n" );

                        commentList = queryData.getComments();
                        for( int commentIndex = 0; commentIndex < commentList.size(); commentIndex++ ){
                            comment = (String)commentList.get(commentIndex);
                            reportBuff.write( "\t\t" + comment + "\n" );                 
                        }
                    }
                }
                for( int commentIndex = 0; commentIndex < commentList.size(); commentIndex++ ){
                    comment = (String)commentList.get(commentIndex);
                    reportBuff.write("\t" + comment + "\n");                       
                }
            }
        }

        reportBuff.write( "---------------------------------\n");
        return reportBuff.toString();
    }
//------------------------------------------------------------------------------     

}
