/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
package org.ideahamster.metis.report;

import faust.sacha.web.data.*;
import org.ideahamster.metis.stat.*;
import java.io.*;

/**
 * @author Sacha Faust
 * @version <PRE>1.3</PRE>
 */
public abstract class MetisReport {

    protected RandomAccessFile m_reportFile;
    protected Site m_site;
    protected SiteStats m_siteStats;
    protected int m_siteTotalElements;
    
    protected MetisReport( String fileName ) {
        File reportFile = null;

        try{
            reportFile = new File(fileName);
            if( reportFile.exists() )
                reportFile.delete();
        }
        catch( NullPointerException nullEx ){
            System.err.println("MetisReport::MetisReport : " + nullEx );
            System.exit(0);
        }
        catch( SecurityException securityEx ){
            System.err.println("MetisReport::MetisReport : " + securityEx );
            System.exit(0);            
        }
        
        try{
            m_reportFile = new RandomAccessFile(reportFile, "rw" );
        }
        catch( FileNotFoundException notFoundEx ){
            System.err.println("MetisReport::MetisReport(String) : " + notFoundEx);
            System.exit(1);
        }
    }
//------------------------------------------------------------------------------
    public MetisReport( Site site, SiteStats siteStats ){
        // setting the filename to the site domainname with no extension
        //this( site.getDomain() );
        
        m_site = site;
        m_siteStats = siteStats;
    }
//------------------------------------------------------------------------------
    public MetisReport( Site site, SiteStats siteStats, String fileName ){
        this(fileName);

        m_site = site;
        m_siteStats = siteStats;
    }
//------------------------------------------------------------------------------
    public void close(){
        try{
            m_reportFile.close();
        }
        catch( IOException ioEx ){
            System.err.println("MetisReport::close() : " + ioEx.toString());
        }
    }
//------------------------------------------------------------------------------
    protected void setSite( Site site ){
        m_site = site;
    }
//------------------------------------------------------------------------------
    protected void setSiteStats( SiteStats siteStats ){
        m_siteStats = siteStats;
    }
//------------------------------------------------------------------------------
    protected void setFile( RandomAccessFile reportFile ){
        m_reportFile = reportFile;
    }
//------------------------------------------------------------------------------    
    public void generateReport(){
        
        try{
            m_reportFile.write( generateHeaderReport().getBytes() );
            m_reportFile.write( generateFileByTypeReport().getBytes() );
            m_reportFile.write( generateFolderReport().getBytes() );
            m_reportFile.write( generateEmailByDomainReport().getBytes() );
            m_reportFile.write( generateFileInfoReportByFolder().getBytes() );
            m_reportFile.write( generateCommentsByFileReport().getBytes() );
            m_reportFile.write( generateScriptReport().getBytes() );
            m_reportFile.write( generateOutsideURLByDomainReport().getBytes() );
            
            //always the to last sections. Add sections over
            m_reportFile.write( generateSiteMapReport().getBytes() );            
            m_reportFile.write( generateFootNote().getBytes() );
        }
        catch( IOException ioEx ){
            System.err.println("MetisReport::generateReport() : " + ioEx.toString() );
        }
    }
//------------------------------------------------------------------------------
    protected abstract String generateHeaderReport();
//------------------------------------------------------------------------------
    protected abstract String generateFileByTypeReport();
//------------------------------------------------------------------------------    
    protected abstract String generateFolderReport();
//------------------------------------------------------------------------------    
    protected abstract String generateEmailByDomainReport();
//------------------------------------------------------------------------------
    protected abstract String generateOutsideURLByDomainReport();
//------------------------------------------------------------------------------    
    protected abstract String generateSiteMapReport();
//------------------------------------------------------------------------------    
    protected abstract String generateFileInfoReportByFolder();
//------------------------------------------------------------------------------    
    protected abstract String generateCommentsByFileReport();
//------------------------------------------------------------------------------
    protected abstract String generateScriptReport();
//------------------------------------------------------------------------------    
    protected abstract String generateFootNote();
//------------------------------------------------------------------------------
}
