/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.util;

import java.util.*;
import java.io.*;

public final class WebGlobal {
    public static final int HTTP_DEFAULT_PORT               = 80;
    public static final int HTTPS_DEFAULT_PORT              = 443;
    public static final String PROTOCOL_DEFAULT             = "http://";
    
    public static final String PROTOCOL_LIST[] = {
                                                    "http://",
                                                    "https://",
                                                    "ftp://",
                                                    "telnet://",
                                                    "rmi://",
                                                    "ldap://",
                                                    "mailto:"
                                                 };
                                                 
    public static final String NON_HTTP_PROTOCOLS_LIST[] = {
                                                                "ftp://",
                                                                "telnet://",
                                                                "rmi://",
                                                                "ldap://"
                                                            };
                                                            
                                                 
    public static final int REQUEST_METHOD_GET              = 1;
    public static final int REQUEST_METHOD_HEAD             = 2;
    public static final int REQUEST_METHOD_POST             = 3;
    public static final int REQUEST_METHOD_DELETE           = 4;
    
    public static int DEFAULT_PORT                          = HTTP_DEFAULT_PORT;
    public static int REQUEST_METHOD                        = REQUEST_METHOD_GET;
    
    public static final int URL_TYPE_FILE                   = 1;
    public static final int URL_TYPE_FOLDER                 = 2;
    
    public static boolean DEBUG                             = false;
    public static String USER_AGENT                         = "Riding the Snake v1.3";
    
    public static String PROXY_HOST                         = "";
    public static int PROXY_PORT                            = 80;
    //public static String PROXY_USERNAME                     = null;
    //public static String PROXY_PASSWORD                     = null;
    public static String HTTP_USER                          = "";
    public static String HTTP_PASSWORD                      = "";
    
    public static boolean FOLLOW_INSIDE_REDIRECT            = false;
    public static boolean FOLLOW_OUTSIDE_REDIRECT           = false;
    
    public static int MAX_REQUEST_DOWNLOAD                  = 1572864;
    public static String POTENTIAL_HTML_FILE_EXT[]    = {
                                                            "htm",
                                                            "html",
                                                            "shtml",
                                                            "stm",      //  jeff site
                                                            "pl",       //  perl
                                                            "cfm",      //  Cold Fusion
                                                            "php",      //  PHP
                                                            "php3",     //  PHP
                                                            "mv",       //  Miva Merchand
                                                            "cgi",
                                                            "asp",      //  Active Server Pages
                                                            "css"   };
                                                            

    private static int TIMEOUT_RETRIES                      = 0;
    
    public static final String PROPERTY_FILE_NAME = "webglobal.properties";
    public static final String PROPERTY_FOLDER = "conf";
    public static final String PROPERTY_FILE_LOCATION = PROPERTY_FOLDER + File.separator + PROPERTY_FILE_NAME;
    
////////////////////////////////////////////////////////////////////////////////   
    
    public WebGlobal() {
    }
//------------------------------------------------------------------------------
    public static void initProperties(){
        Properties props = null;
        Enumeration propKeys = null;
        
        if( (props = loadPropertiesFile()) == null ){
            props = new Properties();
            fillProperties(props);
            writePropertyFile();
            
        }
        else{
            USER_AGENT = props.getProperty("useragent", USER_AGENT);
            resetHTMLExtListFromProperties( props.getProperty("potential_html_file_ext", null) );

            PROXY_HOST = props.getProperty("proxy_host", PROXY_HOST);
            
            HTTP_USER = props.getProperty("http_user", HTTP_USER);
            HTTP_PASSWORD = props.getProperty("http_password", HTTP_PASSWORD);
            
            try{
                // ether I'm very tired but casting int to boolean shouldn't be this complicated ...
                DEBUG = Integer.decode( props.getProperty("debug", String.valueOf( (DEBUG?1:0)) ) ).intValue() == 1 ? true : false;
                FOLLOW_INSIDE_REDIRECT = Integer.decode( props.getProperty("follow_inside_redirect", String.valueOf(FOLLOW_INSIDE_REDIRECT)) ).intValue() == 1 ? true : false;
                FOLLOW_OUTSIDE_REDIRECT = Integer.decode( props.getProperty("follow_outside_redirect", String.valueOf(FOLLOW_OUTSIDE_REDIRECT)) ).intValue() == 1 ? true : false;
                DEFAULT_PORT = Integer.decode( props.getProperty("default_port", String.valueOf(DEFAULT_PORT)) ).intValue();
                PROXY_PORT = Integer.decode( props.getProperty("proxy_port", String.valueOf(PROXY_PORT)) ).intValue();
                TIMEOUT_RETRIES = Integer.decode( props.getProperty("timeout_retries", String.valueOf(TIMEOUT_RETRIES)) ).intValue();
                MAX_REQUEST_DOWNLOAD = Integer.decode( props.getProperty("max_request_download", String.valueOf(MAX_REQUEST_DOWNLOAD)) ).intValue();
            }
            catch( NumberFormatException numEx ){
                System.err.println("Unable to parse property file : " + numEx + " . Will be using default!");
            }
        }
    }
//------------------------------------------------------------------------------
    private static void fillProperties( Properties props ){
            props.put( (Object)"useragent", (Object)USER_AGENT );
            props.put( (Object)"debug", (Object)String.valueOf(DEBUG ? 1 : 0) );
            props.put( (Object)"follow_inside_redirect", (Object)String.valueOf(FOLLOW_INSIDE_REDIRECT ? 1 : 0 ) );
            props.put( (Object)"follow_outside_redirect", (Object)String.valueOf(FOLLOW_OUTSIDE_REDIRECT ? 1 : 0) );
            props.put( (Object)"default_port", (Object)String.valueOf(DEFAULT_PORT) );
            props.put( (Object)"potential_html_file_ext", (Object)getFileExtList() );
            props.put( (Object)"proxy_host", (Object)PROXY_HOST );
            props.put( (Object)"proxy_port", (Object)String.valueOf(PROXY_PORT) );
            props.put( (Object)"timeout_retries", (Object)String.valueOf(TIMEOUT_RETRIES) );
            props.put( (Object)"http_user", (Object)HTTP_USER );
            props.put( (Object)"http_password", (Object)HTTP_PASSWORD );
            props.put( (Object)"max_request_download", (Object)String.valueOf(MAX_REQUEST_DOWNLOAD) );
    }
//------------------------------------------------------------------------------   
    private static Properties loadPropertiesFile(){
        Properties props = null;
        File propFile = null;
        FileInputStream fileOut = null;
        
        try{
            propFile = new File( PROPERTY_FILE_LOCATION );
        }
        catch( NullPointerException nullEx ){
            return null;
        }
        
        if( !propFile.exists() )
            return null;
        
        try{
            propFile.createNewFile();
            fileOut = new FileInputStream(propFile);
            props = new Properties();
            props.load(fileOut);
        }
        catch( IOException ioEx ){
            return null;
        }
        
        try{
            fileOut.close();
        }
        catch( IOException ioEx ){
            System.err.println("WebGlobal::loadPropertyFile() : " + ioEx);
        }
        
        return props;
    }
//------------------------------------------------------------------------------
    private static void writePropertyFile(){
        FileOutputStream propFile = null;
        Properties props = new Properties();
        
        if( !setFolderPropertyFolder() )
            return;
        
        try{
            propFile = new FileOutputStream(PROPERTY_FILE_LOCATION);
        }
        catch( IOException ioEx ){
            System.err.println("WebGlobal::writePropertyFile() : " + ioEx);
            return;
        }
                
        try{
            fillProperties(props);
            props.store( (OutputStream)propFile, "Properties for controling the spider code" );
            propFile.close();
        }
        catch( IOException ioEx ){
            System.err.println("WebGlobal::writePropertyFile() : unable to store properties : " + ioEx);
        }
        catch( ClassCastException  castEx ){
            System.err.println("WebGlobal::writePropertyFile() : cast problem. Please repor this !: " + castEx);
        }
    }
//------------------------------------------------------------------------------
    private static boolean setFolderPropertyFolder(){
        File folder = null;
        
        try{
            folder = new File(PROPERTY_FOLDER);
        }
        catch( NullPointerException nullEx ){
            System.err.println( "WebGlobal::setFolderPropertyFolder() : " + nullEx );
            return false;
        }
        
        if( folder.exists() )
            return true;
        else{
            try{
                return folder.mkdir();
            }
            catch( SecurityException secEx ){
                System.err.println( "WebGlobal::setFolderPropertyFolder() : " + secEx );
                return false;
            }
        }
    }
//------------------------------------------------------------------------------    
    private static String getFileExtList(){
        StringBuffer extString = new StringBuffer();

        for( int i = 0; i < POTENTIAL_HTML_FILE_EXT.length; i++ )
            extString.append(POTENTIAL_HTML_FILE_EXT[i] + ";");
        
        return extString.toString();

    }
//------------------------------------------------------------------------------
    private static void resetHTMLExtListFromProperties( String propList ){
        StringTokenizer strToken = null;
        int nbExt = 0;
        String extName = null;
        
        if( propList == null )
            return;
        
        strToken = new StringTokenizer(propList, ";");
        
        if( (nbExt = strToken.countTokens()) == 0 ){
            System.err.println("WebGlobal::resetHTMLExtListFromProperties() : Unable to parser potential_html_file_ext property. Using defaults!");
            return;
        }
        
        //  reset the string elements
        for( int i = 0; i < POTENTIAL_HTML_FILE_EXT.length; i++ )
            POTENTIAL_HTML_FILE_EXT[i] = null;
        
        //  reset the string array
        POTENTIAL_HTML_FILE_EXT = null;
        POTENTIAL_HTML_FILE_EXT = new String[nbExt];
        
        for( int j = 0; strToken.hasMoreTokens(); j++ ){
            extName = strToken.nextToken();
            if( !extName.equals("") )
                POTENTIAL_HTML_FILE_EXT[j] = new String(extName);
        }
    }
//------------------------------------------------------------------------------
    public static void setDebug( boolean mode ){
        DEBUG = mode;
    }
//------------------------------------------------------------------------------
    public static void setUserAgent( String userAgent ){
        USER_AGENT = userAgent;
    }
//------------------------------------------------------------------------------
    public static void followInsideRedirect( boolean redirect ){
        FOLLOW_INSIDE_REDIRECT = redirect;
    }
//------------------------------------------------------------------------------
    public static void followOutsideRedirect( boolean redirect ){
        FOLLOW_OUTSIDE_REDIRECT = redirect;
    }
//------------------------------------------------------------------------------
    public static void setRequestMethod( int requestMethod ){
        REQUEST_METHOD = requestMethod;
    }
//------------------------------------------------------------------------------
    public static void setTimeoutNbRetries( int nb ){
        TIMEOUT_RETRIES = nb;
    }
//------------------------------------------------------------------------------
    public static int getTimeoutNbRetries(){
        return TIMEOUT_RETRIES;
    }
//------------------------------------------------------------------------------    
    public static void DEBUG_DUMP_OPTIONS(){

        System.out.println("DEBUG : " + DEBUG );
        System.out.println("USER_AGENT : " + USER_AGENT );
        System.out.println("FOLLOW_INSIDE_REDIRECT : " + FOLLOW_INSIDE_REDIRECT );
        System.out.println("FOLLOW_OUTSIDE_REDIRECT : " + FOLLOW_OUTSIDE_REDIRECT );
        System.out.println("PROXY_HOST : " + PROXY_HOST );
        System.out.println("PROXY_PORT : " + PROXY_PORT );
        System.out.println("TIMEOUT_RETRIES : " + TIMEOUT_RETRIES );
        System.out.println("HTTP_USER : " + HTTP_USER );
        System.out.println("HTTP_PASSWORD : " + HTTP_PASSWORD );
        System.out.println("PROXY_HOST : " + PROXY_HOST );
        System.out.println("PROXY_PORT : " + PROXY_PORT );
        
        System.out.println("HTML_EXT :");
        for( int i = 0; i < POTENTIAL_HTML_FILE_EXT.length; i++ )
            System.out.println("\t" + POTENTIAL_HTML_FILE_EXT[i]);
        
    }
//------------------------------------------------------------------------------    
    public static void main( String args[] ){
        WebGlobal.initProperties();
        WebGlobal.DEBUG_DUMP_OPTIONS();
    }
}
