/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.util;

import java.util.*;

/** Class use to clean folder that includes . and ..
 * ie : http://site.com/folder/../file
 */
public class FolderCleaner {
    private ArrayList m_folderList;
    private String m_path;
    private String m_cleanPath;
    
    private FolderCleaner(){
        m_folderList = new ArrayList(0);
        m_path = "";
        m_cleanPath = "";
    }
    
    /**
     * @param path The path to clean.
     */    
    public FolderCleaner( String path ) {
        this();
        m_path = path;
        init();
    }
//------------------------------------------------------------------------------
    private void init(){
        initFolderList();
        generateCleanPath();
    }    
//------------------------------------------------------------------------------
    private void initFolderList(){
        StringTokenizer strTokens = new StringTokenizer(m_path, "/");
        String folderChunk = null;
        int dotpos = 0;
        boolean selfDisable = false;
        
        /*
         *Logic:
         *  we loop between each tokens.
         *  if the token is .., we know we need to disable this path and we set selfDisable to true
         *  if the token is ., we know we need to disable this path and we set selfDisable to true
         *  if the token starts to .., we remove the .. 
         *  if the token starts with ., we remove the .
         *  
         *  we add the folder to the array
         *  if selfDisable is true, we disable this item in the array
         */
        for( int index = 0; strTokens.hasMoreTokens(); index++ ){
            folderChunk = strTokens.nextToken();
            
            if( folderChunk.compareTo("..") == 0 ){
                selfDisable = true;
                
                // we also delete the one behind if such element exist
                if( index != 0 )
                    disableFolder( index - 1 );
                
            }
            else if( folderChunk.compareTo(".") == 0 ){
                selfDisable = true;
            }
            else if( folderChunk.startsWith("..") ){
                if( index != 0 )
                    disableFolder( index - 1 );
                else{
                    if( WebGlobal.DEBUG )
                        System.err.println("FolderCleanre::initFolderList() : path is braking out of the webroot : " + m_path );
                }
                folderChunk = folderChunk.substring(2, folderChunk.length());
            }
            else if( folderChunk.startsWith(".") ){
                folderChunk = folderChunk.substring(1 , folderChunk.length());                
            }
            
            addFolderChunk(index, folderChunk);
            
            if( selfDisable )
                disableFolder(index);
            
            //reset to false
            selfDisable = false;
        }
    }
//------------------------------------------------------------------------------
    private void addFolderChunk(int index, String folderChunk ){
        FolderChunkInfo folder = new FolderChunkInfo(folderChunk);
        m_folderList.add(index, (Object)folder);
    }
//------------------------------------------------------------------------------    
    private void disableFolder( int folderID ){
        FolderChunkInfo folderInfo = (FolderChunkInfo)m_folderList.get(folderID);
        folderInfo.setRequired(false);
    }
//------------------------------------------------------------------------------    
    private void generateCleanPath(){
        FolderChunkInfo folderInfo = null;
        
        for( int index = 0; index < m_folderList.size(); index++ ){
            folderInfo = (FolderChunkInfo)m_folderList.get(index);
            if( folderInfo.isRequired() )
                m_cleanPath += "/" + folderInfo.toString();
        }
        
        m_cleanPath += "/";
    }

//------------------------------------------------------------------------------    
    /**
     * @return The real path.
     */    
    public String getCleanPath(){
        return m_cleanPath;
    }
//------------------------------------------------------------------------------
    public String toString(){
        return m_cleanPath;
    }
//------------------------------------------------------------------------------
    private static void main( String args[] ){
        FolderCleaner t = new FolderCleaner("/cgi-bin/allsites/feedback/feed.pl/frndoc/../");
        System.out.println("Clean path = " + t.getCleanPath());
    }
    
}


//##############################################################################
//#### New Class

class FolderChunkInfo{
    
    private String m_folderName;
    private boolean m_required;
    
    private FolderChunkInfo(){
        m_folderName = "";
        m_required = true;
    }
    
    /**
     */    
    public FolderChunkInfo( String folderChunk ){
        this();
        m_folderName = folderChunk;
    }    
//------------------------------------------------------------------------------
    public void setRequired( boolean required ){
        m_required = required;
    }
//------------------------------------------------------------------------------
    public boolean isRequired(){
        return m_required;
    }    
//------------------------------------------------------------------------------
    public String toString(){
        return m_folderName;
    }
//------------------------------------------------------------------------------
    
}
