/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.data;

import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.*;
import faust.sacha.web.util.*;
import java.util.*;
import java.text.*;
import java.net.MalformedURLException;
import java.io.*;

public class URLData extends URLInfo {
    private ArrayList m_links;
    private ArrayList m_comments;
    private ArrayList m_emails;
    
    // Header infor
    private String m_lastModified;
    private long m_contentLength;
    private String m_cookie;
    private String m_serverString;
    private String m_contentType;
    private String m_locationInfo;
    protected Hashtable m_headers;
    
    // for cookies
    boolean m_secure;
    
    public URLData( URLInfo url ) throws java.net.MalformedURLException {
        super(url.getURL());
        
        
        m_links = new ArrayList(0);
        m_comments = new ArrayList(0);
        m_emails = new ArrayList(0);
        m_headers = new Hashtable(0);
        
        
        m_lastModified = "";
        m_contentLength = 0;
        m_cookie = "";
        m_serverString = "";
        m_contentType = "";
        m_locationInfo = "";
        
        m_secure = url.isSecure();
        
    }
    
    public URLData( String strURL ) throws java.net.MalformedURLException{
        this( new URLInfo(strURL) );
    }
    
    public URLData ( String strURL, URLInfo url ) throws java.net.MalformedURLException {
        super(strURL, url);

        m_links = new ArrayList(0);
        m_comments = new ArrayList(0);
        m_emails = new ArrayList(0);
        m_headers = new Hashtable(0);
        
        m_lastModified = "";
        m_contentLength = 0;
        m_cookie = "";
        m_serverString = "";
        m_contentType = "";
        m_locationInfo = "";
        
        m_secure = url.isSecure();        
    }
//------------------------------------------------------------------------------
    public void setHeader( String headerName, String headerContent ){
        Vector contentList = null;
        StringTokenizer strToken = null;
        // only deal with lowercase header name
        headerName = headerName.toLowerCase();
                
        /*
         *  We don't check if the header was already there.
         *  the put() method will crush any value already present
         */
        contentList = new Vector(0);
        contentList.add( (Object)headerContent );
        m_headers.put( (Object)headerName, (Object)contentList );
    }
//------------------------------------------------------------------------------
    public void addHeaderContent( String headerName, String headerContent ){
        Vector contentList = null;
        
        headerName = headerName.toLowerCase();
        
        if( m_headers.containsKey((Object)headerName) ){
            contentList = (Vector)m_headers.get( (Object)headerName );
            contentList.add( (Object)headerContent );
        }
        else{
            contentList = new Vector(0);
            contentList.add( (Object)headerContent );
            m_headers.put( (Object)headerName, (Object)contentList );
        }
    }
//------------------------------------------------------------------------------
    public Vector getHeaderContent( String headerName ){
        Vector contentList = null;
        
        headerName = headerName.toLowerCase();
        contentList = (Vector)m_headers.get( (Object)headerName );
        return contentList;
    }
//------------------------------------------------------------------------------
    public String getHeaderContent( String headerName, int index ){
        Vector contentList = null;
        
        contentList = getHeaderContent(headerName);
        
        if( contentList == null )
            return null;
        else{
            if( index > contentList.size() ){
                if( WebGlobal.DEBUG )
                    System.err.println("URLData::getHeaderContent : requested to big index on : " + getURL() );
                
                return null;
            }
            else
                return (String)contentList.get(index);
        }
    }
//------------------------------------------------------------------------------    
    public boolean isCommentPresent( String commentToCheck ){
        String strComment = null;
        
        for( int i = 0; i < m_comments.size(); i++ ){
            strComment = (String)m_comments.get(i);
            if( strComment.compareToIgnoreCase(commentToCheck) == 0 )
                return true;
        }
        
        return false;
    }
//------------------------------------------------------------------------------
    public boolean isEmailPresent( EmailURL emailToCheck ){
        EmailURL email = null;
        
        for( int i = 0; i < m_emails.size(); i++ ){
            email = (EmailURL)m_emails.get(i);
            if( email.sameAs(emailToCheck) )
                return true;
        }
        return false;
    }    
//------------------------------------------------------------------------------
    public void addLink( String url ){
        //url = url.toLowerCase();
        m_links.add( (Object)url );
    }    
//------------------------------------------------------------------------------
    public void addLinkList( ArrayList links ){
        Object link = null;
        for( int i = 0; i < links.size(); i++ ){
            link = links.get(i);
            if( link instanceof String )
                addLink( (String)links.get(i) );
            else
                System.err.println("URLData::addLinkList() : link is not of type String at position : " + i + " for : " + getURL() ) ;
        }
    }
//------------------------------------------------------------------------------
    public ArrayList getLinks(){
        return m_links;
    }
//------------------------------------------------------------------------------    
    public void addComment( String comment ){
        if( !isCommentPresent(comment) )
            m_comments.add( (Object)comment );
    }
//------------------------------------------------------------------------------
    public void addCommentList( ArrayList comments ){
        Object comment = null;
        
        for( int i = 0; i < comments.size(); i++ ){
            comment = comments.get(i);
            if( comment instanceof String )
                addComment( (String)comments.get(i) );
            else
                System.err.println("URLData::addCommentList() : comment is not of type String at position : " + i);
        }
    }
//------------------------------------------------------------------------------    
    public void addEmail( String email ){
        EmailURL emailUrl = null;
        
        try{
            emailUrl= new EmailURL(email);
            addEmail(emailUrl);
        }
        catch( MalformedURLException urlEx ){
            System.err.println("URLData::addEmail : " + urlEx + " on : " + getURL() );
        }
    }
//------------------------------------------------------------------------------
    public void addEmail( EmailURL email ){
        m_emails.add(email);
    }
//------------------------------------------------------------------------------
    public void addEmailList( ArrayList emails ){
        Object email = null;
        
        for( int i = 0; i < emails.size(); i++ ){
            email = emails.get(i);
            if( email instanceof EmailURL )
                addEmail( (EmailURL)emails.get(i) );
            else
                System.err.println("URLData::addEmailList() : email is not of type EmailURL at position : " + i);
        }
    }
//------------------------------------------------------------------------------
    public ArrayList getEmailList(){
        return m_emails;
    }
//------------------------------------------------------------------------------    
    public void setResponseInfo( Header responseHeaders[] ){
        Header currentHeader = null;
        String headerName = null;
        HeaderElement[] headerContent = null;
        String headerContentValueData = null;
        
        for( int headerIndex = 0; headerIndex < responseHeaders.length; headerIndex++ ){
            currentHeader = responseHeaders[headerIndex];
            headerName = currentHeader.getName();
            //headerContent = currentHeader.getValue();
            
            try{
                headerContent = currentHeader.getValues();
                
                for( int i = 0; i < headerContent.length; i++ ){
                    /*
                     *  This is a fix for the jakarta-commons httpclient package
                     *  where it will split a url in a header if it as a = in it
                     */
                    if( headerName.equalsIgnoreCase("location") || headerName.equalsIgnoreCase("content-location") ){
                        headerContentValueData = headerContent[i].getValue();
                        if( headerContentValueData == null )
                            addHeaderContent( headerName, headerContent[i].getName() );
                        else
                            addHeaderContent( headerName, headerContent[i].getName() + "=" + headerContentValueData );
                    }
                    else
                        addHeaderContent( headerName, headerContent[i].getName() );
                }
            }
            catch( HttpException httpEx ){
                if( WebGlobal.DEBUG )
                    System.err.println("URLData::setResponseInfo() : HttpException : " + httpEx );
                /*
                 *  We just add the string to the header content
                 */
                addHeaderContent( headerName, currentHeader.getValue() );
                
            }

            if( headerName.compareToIgnoreCase("Server") == 0 ){
                setServerInfo( currentHeader.getValue() );
            }
            else if( headerName.compareToIgnoreCase("Content-Type") == 0 ){
                setContentTypeInfo( currentHeader.getValue() );
            }
            else if( headerName.compareToIgnoreCase("Last-Modified") == 0 ){
                setLastModifiedInfo( currentHeader.getValue() );
            }
            else if( headerName.compareToIgnoreCase("Content-Length") == 0 ){
                setContentLengthInfo( currentHeader.getValue() );
            }
            else if( headerName.compareToIgnoreCase("Content-Location") == 0 ){
                setContentLocationInfo( currentHeader.getValue() );
            }
            else if( (headerName.compareToIgnoreCase("Set-Cookie") == 0) || (headerName.compareTo("Cookie") == 0) ){
                setCookieInfo( currentHeader.getValue() );
                
                /*
                 * TODO
                 *  - see TODO on private setCookieInfo( HeaderElement headerElements[] )
                 */
                /*
                try{
                    setCookieInfo( currentHeader.getValues() );
                }
                catch( HttpException httpEx ){
                    System.err.println("URLData::setResponseInfo() : on cookie data : " + curentHeader.getValue() + " | errmsg = " + httpEx.toString() );
                    continue;
                }
                 */
            }
        }
    }
//------------------------------------------------------------------------------
    public void setServerInfo( String serverInfo ){
        m_serverString = serverInfo;
    }
//------------------------------------------------------------------------------
    public String getServerInfo(){
        return m_serverString;
    }
//------------------------------------------------------------------------------    
    public void setContentTypeInfo( String contentTypeInfo ){
        m_contentType = contentTypeInfo;
    }
//------------------------------------------------------------------------------
    public String getContentTypeInfo(){
        return m_contentType;
    }
//------------------------------------------------------------------------------
    public void setLastModifiedInfo( String lastmodifiedInfo ){
        m_lastModified = lastmodifiedInfo;
    }
//------------------------------------------------------------------------------
    public String getLastModifiedInfo(){
        return m_lastModified;
    }
//------------------------------------------------------------------------------    
    public void setContentLengthInfo( String contentLengthInfo ){
        try{
            m_contentLength = Long.parseLong( contentLengthInfo );
        }
        catch( NumberFormatException numEx ){
            System.err.println("URLData::setContentLengthInfo() : " + numEx );
            m_contentLength = 0;
        }
    }
//------------------------------------------------------------------------------
    public void setContentLengthInfo( long contentLengthInfo ){
        m_contentLength = contentLengthInfo;
    }
//------------------------------------------------------------------------------    
    public String getContentLengthInfoAsString(){
        return Long.toString(m_contentLength);
    }
//------------------------------------------------------------------------------
    public long getContentLengthInfo(){
        return m_contentLength;
    }
//------------------------------------------------------------------------------    
    public void setContentLocationInfo( String locationInfo ){
        m_locationInfo = locationInfo;
    }
//------------------------------------------------------------------------------
    public String getContentLocationInfo(){
        return m_locationInfo;
    }
//------------------------------------------------------------------------------
    
    /*
     * TODO:
     *  - See if we can parse this correctly everytime without braking
     *  and create a Cookie instance
     *
     *  - Replace to protected once method is finish so subclass can see it
     */
    private void setCookieInfo( HeaderElement headerElements[] ){
        
        
    }
//------------------------------------------------------------------------------
    public void setCookieInfo( String cookieInfo ){
        m_cookie = cookieInfo;
    }
//------------------------------------------------------------------------------
    public String getCookieInfo(){
        return m_cookie;
    }
//------------------------------------------------------------------------------
    public ArrayList getComments(){
        return m_comments;
    }   
//------------------------------------------------------------------------------
    public Hashtable getHeaders(){
        return m_headers;
    }
//------------------------------------------------------------------------------    
   
    public void DEBUG_dump(){
        
        Enumeration headerKeys = null;
        String headerName = null;
        Vector headerContent = null;
        
        headerKeys = m_headers.keys();
        
        while( headerKeys.hasMoreElements() ){
            headerName = (String)headerKeys.nextElement();
            headerContent = (Vector)m_headers.get( (Object)headerName );
            
            System.err.println("HeaderName = " + headerName );
            for( int i = 0; i < headerContent.size(); i++ )
                System.err.println("\tcontent["+i+"] : " + (String)headerContent.get(i) );
        }
    }
    
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
    
    public static void main( String args[] ){

        URLInfo u = null;
        URLData d = null;
        HttpConnection c = null;
        //GetMethod get = new GetMethod("/");
        HeadMethod get = new HeadMethod("/");
        HttpState s = new HttpState();
        Header requestH[] = null;
        
        try{
            u = new URLInfo("http://www.futureshop.com");
            d = new URLData(u);
        }
        catch( java.net.MalformedURLException urlEx ){
            System.err.println(urlEx);
            System.exit(0);
        }
        
        c = new HttpConnection(u.getHost(), u.getPort());
        
        try{
            c.open();
        }
        catch( IOException ioEx ){
            System.err.println("IOEx : " + ioEx);
        }
        
        get.setFollowRedirects(false);
        try{
            get.execute(s, c);
        }
        catch( HttpException httpEx ){
            System.err.println("HttpEx : " + httpEx);
        }
        catch( IOException ioEx ){
            System.err.println("IOEx : " + ioEx);
        }
        
        System.err.println("Status code = " + get.getStatusCode() );
        requestH = get.getResponseHeaders();
        
        d.setResponseInfo(requestH);
        
        String location = null;
        
        switch( get.getStatusCode() ){
            case 302:
                location = d.getHeaderContent( "location", 0 );
                break;
            default:
                location = d.getHeaderContent("content-location", 0);
                break;
        }
        
        System.err.println("Location = " + location);
        
        
        d.DEBUG_dump(); 
    }

}
