/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.data;

import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.*;
import faust.sacha.web.util.*;
import java.io.*;

public class URLCont extends HttpConnection {

    private HttpMethod m_method;
    protected URLInfo m_urlInfo;
    protected HttpState m_connectionState;
    protected UsernamePasswordCredentials m_credentials;
    
    public URLCont( URLInfo url ){
        super( url.getHost(), url.getPort(), url.isSecure() );
        
        m_urlInfo = url;
        m_connectionState = new HttpState();
        m_method = null;
        
        initProxyAndCredentials();
    }
    
    public URLCont( URLInfo url, HttpMethod method ){
        this(url);
        m_method = method;
    }
//------------------------------------------------------------------------------
    private void initProxyAndCredentials(){
        
        if( !WebGlobal.PROXY_HOST.equals("") ){
            try{
                setProxyHost( WebGlobal.PROXY_HOST );
                setProxyPort( WebGlobal.PROXY_PORT );
            }
            catch( IllegalStateException stateEx ){
                System.err.println( "URLCont::URLCont( URLInfo) : " + stateEx );
            }
        }
        
        /*
         *  If any of the 2 var is not "",
         *  we set the credential
         */
        if( !WebGlobal.HTTP_USER.equals("") || !WebGlobal.HTTP_PASSWORD .equals("") ){
            m_credentials = new UsernamePasswordCredentials(WebGlobal.HTTP_USER, WebGlobal.HTTP_PASSWORD);
            /*
             *  Set the global reams credentials
             */
            m_connectionState.setCredentials(null, m_credentials);
        }        
    }
//------------------------------------------------------------------------------    
    public void setMethod( HttpMethod method ){
        m_method = null;
        m_method = method;
    }
//------------------------------------------------------------------------------    
    public String getResponseBodyAsString(){
        
        if(m_method == null ){
            System.err.println("URLCont::getBodyContentAsString() : request while m_method is null");
            return null;
        }
        
        return m_method.getResponseBodyAsString();
    }
//------------------------------------------------------------------------------
    public URLInfo getInfo(){
        return m_urlInfo;
    }
//------------------------------------------------------------------------------
    public String getPath(){
        return m_urlInfo.getPath();
    }
//------------------------------------------------------------------------------
    public String getURL(){
        return m_urlInfo.getURL();
    }
//------------------------------------------------------------------------------
    public String toString(){
        return m_urlInfo.getURL();
    }
//------------------------------------------------------------------------------
    public HttpState getState(){
        return m_connectionState;
    }
//------------------------------------------------------------------------------
    public void purgeCookies(){
        m_connectionState.purgeExpiredCookies();
    }
//------------------------------------------------------------------------------
    /*
    private static void main( String args[] ){

            URLInfo t = new URLInfo("http://test.com:80/testing/file.gsx");
            URLCont s = new URLCont(t);
            
            try{
                s.open();
            }
            catch( IOException ioeEx ){
                System.err.println(ioeEx);
            }
    }
     */
}
