/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.data;

import faust.sacha.web.util.*;
import java.text.ParseException;
import java.net.MalformedURLException;
import java.util.regex.*;

public class SimpleJavaScriptURLGetter extends SimpleJavaScriptCallInfo {
   
    protected String m_urlRef;
    
    public SimpleJavaScriptURLGetter( String javascriptCall ) throws ParseException {
        super(javascriptCall);
        m_urlRef = null;

        searchForURL();
    }
//------------------------------------------------------------------------------
    private void searchForURL(){
        String urlStr = null;
        
        if( m_methodName.equals("open") ){    //open(URL, windowName, windowFeatures)
            urlStr = getArgument(0);
            
            if( WebGlobal.DEBUG )
                System.err.println("SimpleJavaScriptURLGetter::searchForURL() : found url in open() : " + urlStr);
        }
        else if( m_methodName.equals("redirect") ){     //redirect(location)
            urlStr = getArgument(0);
            
            if( WebGlobal.DEBUG )
                System.err.println("SimpleJavaScriptURLGetter::searchForURL() : found url in redirect() : " + urlStr);
        }
        else if( m_methodName.equals("replace") ){       //replace("URL")
            urlStr = getArgument(0);
            
            if( WebGlobal.DEBUG )
                System.err.println("SimpleJavaScriptURLGetter::searchForURL() : found url in replace() : " + urlStr);
        }
        else{
            urlStr = lookForURLinArgument();
        }
        
        if( urlStr != null )
           setURLRef(urlStr);
    }
//------------------------------------------------------------------------------
    private String lookForURLinArgument(){
        String tmpStr = null;
        URLInfo tmpURL = null;
        int pos = 0;
        int strLength = 0;
        Pattern protocolPattern = Pattern.compile("^([a-zA-Z0-9]{1,5}://)");    // find protocol pattern at the beginning of the script
        Pattern fileExtPattern = Pattern.compile("(\\.[a-zA-Z0-9]{1,4})$");     // find file extension pattern at the end of the string
        Matcher patternMatcher = null;
        
        for( int i = 0; i < m_arguments.size(); i++ ){
            tmpStr = (String)m_arguments.get(i);
            strLength = tmpStr.length();
            
            if( tmpStr.toLowerCase().startsWith("http://") || tmpStr.toLowerCase().startsWith("https://") ){
                if( WebGlobal.DEBUG )
                    System.err.println("SimpleJavaScriptURLGetter::lookForURLinArgument() : found url : " + tmpStr);
                
                return tmpStr;                
            }
            
            /*
             *  We check for mail link
             */
            if( tmpStr.toLowerCase().startsWith("mailto:") ){
                if( WebGlobal.DEBUG )
                    System.err.println("SimpleJavaScriptURLGetter::lookForURLinArgument() : found mailto on : " + tmpStr );
                    
                return tmpStr;
            }
            
            /*
             *  We check for mis protocol urls
             */
            patternMatcher = protocolPattern.matcher(tmpStr);
            if( patternMatcher.find() ){
                if( WebGlobal.DEBUG )
                    System.err.println("SimpleJavaScriptURLGetter::lookForURLinArgument() : found url with misc protocol : " + patternMatcher.group() + " on : " + tmpStr );
                
                return tmpStr;        
            }
            
            /*
             *  We check if we can find a potential filename extension
             */
            patternMatcher = fileExtPattern.matcher(tmpStr);
            if( patternMatcher.find() ){
                if( WebGlobal.DEBUG )
                    System.err.println("SimpleJavaScriptURLGetter::lookForURLinArgument() : found url : " + tmpStr);
                     
                return tmpStr;
            }
        }
        
        return null;
    }
//------------------------------------------------------------------------------
    protected void setURLRef( String urlStr ){
        m_urlRef = urlStr;
    }
//------------------------------------------------------------------------------
    public String getURLRef(){
        return m_urlRef;
    }
//------------------------------------------------------------------------------ 
//------------------------------------------------------------------------------
    static public void main( String args[] ) throws ParseException  {
        WebGlobal.setDebug(true);

        SimpleJavaScriptURLGetter s  = new SimpleJavaScriptURLGetter("javascript:openIt('/privacy/default.stm')" );
    }
}
