/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.data;

import faust.sacha.web.util.WebGlobal;
import java.text.ParseException;
import java.util.*;

public class SimpleJavaScriptCallInfo {
    protected String m_javascriptCall;
    protected String m_methodName;
    protected String m_objectName;
    protected Vector m_arguments;
    
    public SimpleJavaScriptCallInfo( String javascriptCall ) throws ParseException{
        m_arguments = new Vector(0);
        
        // little cleanup
        javascriptCall = javascriptCall.trim();
        
        if( javascriptCall.toLowerCase().startsWith("javascript:") )
            m_javascriptCall = javascriptCall.substring(11, javascriptCall.length());   // 11 = javascript:
        else
            m_javascriptCall = javascriptCall;
        
        init();
    }
//------------------------------------------------------------------------------
    private void init() throws ParseException{
        setObjectAndMethodCall();
        setArguments();
    }
//------------------------------------------------------------------------------
    private void setObjectAndMethodCall() throws ParseException{
        int posIndex = 0;
        StringTokenizer strToken = null;
        String tmpStr = null;
        int index = 0;
        
        /*
         *  Find the method and argument delimitor
         */
        posIndex = m_javascriptCall.indexOf( '(' );
        
        if( posIndex <= 0 ){
            if( WebGlobal.DEBUG )
                System.err.println("SimpleJavaScriptCallInfo::setMethodCall() : posIndex = " + posIndex + " : on " + m_javascriptCall );
            
            throw( new ParseException("Unable to parse : " + m_javascriptCall + " : on setMethodCall()", 1) );
        }
        
        tmpStr = m_javascriptCall.substring(0, posIndex);
        strToken = new StringTokenizer(tmpStr, ".");
        
        if( strToken.countTokens() > 2 ){
            if( WebGlobal.DEBUG )
                System.err.println("SimpleJavaScriptCallInfo::setMethodCall() : nb tokens > 2 : " + strToken.countTokens() + " on " + m_javascriptCall );
            
            throw( new ParseException("Unable to parse : " + m_javascriptCall + " : on setMethodCall()", 2) );
        }
        
        if( strToken.countTokens() == 1 )      //only as a method name so we get first token
            m_methodName = strToken.nextToken();
        else{
            while( strToken.hasMoreTokens() ){
                tmpStr = strToken.nextToken();

                switch( index ){
                    case 0:
                        m_objectName = tmpStr.toLowerCase();
                        break;
                    case 1:
                        m_methodName = tmpStr.toLowerCase();
                        break;
                    default:
                        System.err.println("CODE ERROR : SimpleJavaScriptCallInfo::setMethodCall() : index = " + index);
                        throw( new ParseException("Unable to parse : " + m_javascriptCall + " : on setMethodCall()", 3) );
                }

                index++;
            }
        }
    }
//------------------------------------------------------------------------------
    private void setArguments() throws ParseException{
        int deliFirst = 0;
        int deliLast = 0;
        String argumentList = null;
        String argumentStr = null;
        int argumentIndex = 0;
        
        deliFirst = m_javascriptCall.indexOf( '(' );
        deliLast = m_javascriptCall.lastIndexOf( ')' );
        
        if( (deliFirst <= 0) || (deliLast <= 0) ){
            if( WebGlobal.DEBUG )
                System.err.println("SimpleJavaScriptCallInfo::setArguments() : deliFirst = " + deliFirst + " deliLast = " + deliLast + " on " + m_javascriptCall );
            
            throw( new ParseException("Unable to parse : " + m_javascriptCall + " : on setArguments()", 1) );
        }
        
        /*
         *  Retreive the argument string
         */
        argumentList = m_javascriptCall.substring(deliFirst + 1, deliLast);
        
        deliFirst = 0;
        deliLast = 0;
        
        while( true ){
            if( (deliFirst = argumentList.indexOf("'",deliLast)) == -1 )
                break;
            if( (deliLast = argumentList.indexOf("'", deliFirst + 1)) == -1 ){
                if( WebGlobal.DEBUG )
                    System.err.println("SimpleJavaScriptCallInfo::setArguments() : argument with no ending found  on : " + argumentList );

                /*
                 *  Set the deliLast to the end of the argumentList string
                 *  this will set the argument correctly and next loop it will break 
                 *  since no more ' will be found
                 */

                deliLast = argumentList.length();
            }
            
            argumentStr = argumentList.substring(deliFirst+1, deliLast);
            
            argumentStr = argumentStr.trim();
            if( argumentStr.startsWith(",") || argumentStr.equals("") )
                continue;
            
            m_arguments.add(argumentIndex, (Object)argumentStr);
            
            argumentIndex++;
        }
    }
//------------------------------------------------------------------------------
    public String getObjectName(){
        return m_objectName;
    }
//------------------------------------------------------------------------------
    public String getMethodName(){
        return m_methodName;
    }
//------------------------------------------------------------------------------
    public String getJavascriptCall(){
        return m_javascriptCall;
    }
//------------------------------------------------------------------------------
    public Vector getArguments(){
        return m_arguments;
    }
//------------------------------------------------------------------------------
    public String getArgument( int index ){
        return (String)m_arguments.get(index);
    }
//------------------------------------------------------------------------------    
    public void DEBUG_dumpInfo(){
        System.err.println("m_javascriptCall = " + m_javascriptCall);
        System.err.println("m_objectName = " + m_objectName);
        System.err.println("m_methodName = " + m_methodName);
        System.err.println("m_arguments : " );
        for(int i = 0; i < m_arguments.size(); i++ ){
            System.err.println("\t1 - " + (String)m_arguments.get(i) );
        }

    }
//------------------------------------------------------------------------------
    static public void main( String args[] ) throws ParseException {
        //WebGlobal.setDebug(true);
        
        SimpleJavaScriptCallInfo s = new SimpleJavaScriptCallInfo("addtowish('/products/Wishlist/1,1586,,00.html', 'dfdf',      '  jkjkdjfkjdkjf ')");
        s.DEBUG_dumpInfo();
    }
}
