/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.data;

import java.util.*;
import faust.sacha.web.util.*;

public class ScriptStateInfo extends URLData{

    public ScriptStateInfo( URLInfo url ) throws java.net.MalformedURLException {
        super(url);
    }
    
    public ScriptStateInfo( URLData url ) throws java.net.MalformedURLException {
        this( (URLInfo)url );
        
        m_headers = url.getHeaders();
        
        // Links
        super.addLinkList( url.getLinks() );
        
        // emails
        super.addEmailList( url.getEmailList() );
        
        // comments
        super.addCommentList( url.getComments() );
        
        // cookies
        super.setCookieInfo( url.getCookieInfo() );
        
        // server
        super.setServerInfo( url.getServerInfo() );
        
        // last modified
        super.setLastModifiedInfo( url.getLastModifiedInfo() );
        
        // content length
        super.setContentLengthInfo( url.getContentLengthInfo() );
        
        // content type
        super.setContentTypeInfo( url.getContentTypeInfo() );
        
        // content location
        super.setContentLocationInfo( url.getContentLocationInfo() );        
        
    }
}
/*
    
    ArrayList m_linkList;
    ArrayList m_emailList;
    ArrayList m_commentList;
    //ArrayList m_cookie;
    
    public ScriptStateInfo() {
        m_linkList = new ArrayList(0);
        m_emailList = new ArrayList(0);
        m_commentList = new ArrayList(0);
    }
//------------------------------------------------------------------------------
    public void addLinkList( ArrayList linkList ){
        Object link = null;
        
        if( linkList == null ){
            System.err.println("ScriptStateInfo::addComentList() : linkList is null");
            return;
        }
        
        for( int i = 0; i < linkList.size(); i++ ){
            link = linkList.get(i);
            if( link instanceof String )
                addLink( (String)link );
            else{
                System.err.println("ScriptStateInfo::addLinkList() : link is not instance of String but instance of : " + link.getClass().getName() );
                
                continue;
            }
        }
    }
//------------------------------------------------------------------------------    
    public void addLink( String link ){
        if( !linkPresent(link) )
            m_linkList.add( (Object)link );
    }
//------------------------------------------------------------------------------
    public void addEmailList( ArrayList emailList ){
        Object email = null;

        if( emailList == null ){
            System.err.println("ScriptStateInfo::addComentList() : emailList is null");
            return;
        }
        
        for( int i = 0; i < emailList.size(); i++ ){
            email = emailList.get(i);
            if( email instanceof EmailURL )
                addEmail( (EmailURL)email );
            else{
                System.err.println("ScriptStateInfo::addEmailList() : email is not instance of EmailURL but instance of : " + email.getClass().getName() );
                
                continue;
            }
        }
    }
//------------------------------------------------------------------------------   
    public void addEmail( EmailURL email ){
        if( !emailPresent(email) )
            m_emailList.add( (Object)email );
    }
//------------------------------------------------------------------------------
    public void addComentList( ArrayList commentList ){
        Object comment = null;
        
        if( commentList == null ){
            System.err.println("ScriptStateInfo::addComentList() : commentList is null");
            return;
        }
        
        for( int i = 0; i < commentList.size(); i++ ){
            comment = commentList.get(i);
            
            if( comment instanceof String )
                addComment( (String)comment );
            else{
                System.err.println("ScriptStateInfo::addComentList() : comment is not instance of String but instance of : " + comment.getClass().getName() );
                
                continue;                
            }
            
            
        }
        
        
    }
//------------------------------------------------------------------------------    
    public void addComment( String comment ){
        m_commentList.add( (Object)comment );
    }
//------------------------------------------------------------------------------
    public ArrayList getLinkList(){
        return m_linkList;
    }
//------------------------------------------------------------------------------
    public ArrayList getEmailList(){
        return m_emailList;
    }
//------------------------------------------------------------------------------
    public ArrayList getCommentList(){
        return m_commentList;
    }
//------------------------------------------------------------------------------
    private boolean linkPresent( String linkToCheck ){
        String link = null;
        
        for( int i = 0; i < m_linkList.size(); i++ ){
            link = (String)m_linkList.get(i);
            if( link.compareToIgnoreCase(linkToCheck) == 0 )
                return true;
        }
        
        return false;
    }
//------------------------------------------------------------------------------
    private boolean emailPresent( EmailURL emailToCheck ){
        EmailURL email = null;
        
        for( int i = 0; i < m_emailList.size(); i++ ){
            email = (EmailURL)m_emailList.get(i);
            if( email.sameAs(emailToCheck) )
                return true;
        }    
        return false;
    }
//------------------------------------------------------------------------------
  
}
*/
