/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.data;

import faust.sacha.web.util.*;
import java.util.*;

public class FolderURL extends URLData {
    private ArrayList m_files;
    private String m_folderName;
    
    public FolderURL( URLInfo url ) throws java.net.MalformedURLException {
        super(url);
        
        m_files = new ArrayList(0);
    }
//------------------------------------------------------------------------------
    protected boolean isFilePresent( FileURL fileToCheck ){
        FileURL fileTmp = null;
        URLInfo fileInfo = null;
        
        for( int i = 0; i < m_files.size(); i++ ){
            fileTmp = (FileURL)m_files.get(i);
            if( fileTmp.sameAs(fileToCheck) )
                return true;
        }
        return false;
    }
//------------------------------------------------------------------------------
    public String getFolderName(){
        return super.getFolder();
    }
//------------------------------------------------------------------------------
    public void addFile( FileURL fileToAdd ){
        if( !isFilePresent(fileToAdd) )
            m_files.add( (Object)fileToAdd );        
    }
//------------------------------------------------------------------------------
    public ArrayList getFileList(){
        return m_files;
    }
//------------------------------------------------------------------------------    
    

}
