/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.data;

import java.util.*;
import java.net.MalformedURLException;

public class EmailURL {
    private String m_emailAddress;
    private String m_userName;
    private String m_domain;
    private Hashtable m_argumentHash;
    private String m_fullEmailLink;

    private EmailURL() {
        m_emailAddress = "";
        m_userName = "";
        m_domain = "";
        m_argumentHash = new Hashtable(0);
        m_fullEmailLink = "";
    }

    public EmailURL( String email ) throws MalformedURLException {
        this();
        String cleanEmail = null;
        
        if( email.equals("") || (email == null) )
            throw( new MalformedURLException("Empty email") );
        
        cleanEmail = email.toLowerCase();

        if( cleanEmail.startsWith("mailto:") ){
            int pos_colon = cleanEmail.indexOf(":");
            cleanEmail = cleanEmail.substring(pos_colon + 1);

        }
        m_fullEmailLink = cleanEmail;
        setEmailInfo();
        validateEmail();
    }
//------------------------------------------------------------------------------
    private void validateEmail() throws MalformedURLException {

        if( m_emailAddress.equals("") || m_userName.equals("") || m_domain.equals("") )
            throw( new MalformedURLException("Unable to parse email : " + m_fullEmailLink) );
        else if( m_domain.startsWith(".") )
            throw( new MalformedURLException("Invalid email : " + m_fullEmailLink) );
        
    }
//------------------------------------------------------------------------------
    protected void setEmailInfo() throws MalformedURLException {

       int pos_arg;
       int pos_at;
       String argumentChunk = null;

       //getting the m_emailAddress
       if( (pos_arg = m_fullEmailLink.indexOf("?")) == -1 ){      //delimiting arguments and e-mail
           if( (pos_arg = m_fullEmailLink.indexOf("&")) == -1 ){
               // no argument delimiter, we have a clean e-mail
               m_emailAddress = m_fullEmailLink;
           }
           else
               throw( new MalformedURLException("Unable to parse email. Agument delimiter without query in : " + m_fullEmailLink) );
       }
       else
           m_emailAddress = m_fullEmailLink.substring(0, pos_arg);

       //getting username
       if( (pos_at = m_emailAddress.indexOf("@")) != -1 ){
           m_userName = m_emailAddress.substring( 0, pos_at);

           //getting domain
           m_domain = m_emailAddress.substring(pos_at + 1, m_emailAddress.length());
       }
       else
           throw( new MalformedURLException("Unable to parse email : " + m_fullEmailLink) );

       if( pos_arg != -1 ){     // there is arguments
           argumentChunk = m_fullEmailLink.substring(pos_arg +1);
           setArgumentData(argumentChunk);
       }
    }
//------------------------------------------------------------------------------
    protected void setArgumentData( String arguments ){
        StringTokenizer strTk = new StringTokenizer(arguments, "&");

        while( strTk.hasMoreTokens() ){
            String argBlock = strTk.nextToken();
            String argKey = null;
            String argData = null;
            int pos_equal;


            /*
             * we split the string in 2 with the first = caracter
             * left = argument key,
             * right = argument data
             */
            pos_equal = argBlock.indexOf("=");
            if( pos_equal == -1 ){
                argKey = argBlock;
                argData = new String("");
            }
            else{
                argKey = argBlock.substring(0, pos_equal);
                argData = argBlock.substring(pos_equal+1, argBlock.length());
            }
            //adding the info to the HashTable
            if( !m_argumentHash.containsKey((Object)argKey) )
                m_argumentHash.put((Object)argKey, argData);
            else
                System.err.println("EmailURL::setArgumentData() : duplicate argument name in e-mail link : " + argKey);
        }

    }
//------------------------------------------------------------------------------
    public String getEmail(){
        return m_emailAddress;
    }
//------------------------------------------------------------------------------
    public String getUser(){
        return m_userName;
    }
//------------------------------------------------------------------------------
    public String getDomain(){
        return m_domain;
    }
//------------------------------------------------------------------------------
    public Hashtable getArgumentData(){
        return m_argumentHash;
    }
//------------------------------------------------------------------------------
    public String getEmailURL(){
        return m_fullEmailLink;
    }
//------------------------------------------------------------------------------
    public String getSubject(){
        String subject = (String)m_argumentHash.get( (Object)"subject" );
        if( subject == null )
            subject = "";
        
        return subject;
    }
//------------------------------------------------------------------------------    
    public boolean sameAs( EmailURL emailToCompare ){
        if( m_fullEmailLink.compareToIgnoreCase(emailToCompare.getEmailURL()) == 0 )
            return true;
        else
            return false;
    }
//------------------------------------------------------------------------------
    public Enumeration getArgumentVarNames(){
        return m_argumentHash.keys();
    }
//------------------------------------------------------------------------------
    public String getArgumentVarData( String varName ){
        if( !m_argumentHash.containsKey( (Object)varName ) )
            return null;
        
        return (String)m_argumentHash.get( (Object)varName );
    }
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
    private void DEBUG_DUMP_DATA(){
        System.out.println("full email : " + getEmailURL() );        
        System.out.println("email : " + getEmail() );
        System.out.println("user : " + getUser() );
        System.out.println("domain : " + getDomain() );
        System.out.println("subject : " + getSubject() );
        System.out.println("arguments : " + getArgumentData() );
    }
}
