/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.bot.spider.event;

import faust.sacha.web.util.WebGlobal;
import java.io.*;
import java.util.*;

public class ThreadManager extends ThreadEventManager {

    private static int m_nbCurrentThreads;
    private static int MAX_THREADS = 100;
    private Object m_nbCurrentThreadsMutex;
    
    public static final String PROPERTY_FILE_NAME = "threadmanager.properties";
    public static final String PROPERTY_FILE_LOCATION = WebGlobal.PROPERTY_FOLDER + File.separator + PROPERTY_FILE_NAME;
        
    public ThreadManager() {
        super("ThreadManager");
        m_nbCurrentThreads = 0;
        m_nbCurrentThreadsMutex = new Object();
        
        initProperties();
    }
//------------------------------------------------------------------------------
    public void initProperties(){
        Properties props = null;
        Enumeration propKeys = null;
        
        if( (props = loadPropertiesFile()) == null ){
            props = new Properties();
            fillProperties(props);
            writePropertyFile();
            
        }
        else{
            try{
                MAX_THREADS = Integer.decode( props.getProperty("max_threads", String.valueOf(MAX_THREADS)) ).intValue();
            }
            catch( NumberFormatException numEx ){
                System.err.println( getName() + "::initProperties() : Unable to parse property file : " + numEx + " . Will be using default!");
            }
        }
    }
//------------------------------------------------------------------------------
    private void fillProperties( Properties props ){
        props.put( (Object)"max_threads", (Object)String.valueOf(MAX_THREADS) );
    }
//------------------------------------------------------------------------------   
    private Properties loadPropertiesFile(){
        Properties props = null;
        File propFile = null;
        FileInputStream fileOut = null;
        
        try{
            propFile = new File( PROPERTY_FILE_LOCATION );
        }
        catch( NullPointerException nullEx ){
            return null;
        }
        
        if( !propFile.exists() )
            return null;
        
        try{
            propFile.createNewFile();
            fileOut = new FileInputStream(propFile);
            props = new Properties();
            props.load(fileOut);
        }
        catch( IOException ioEx ){
            return null;
        }
        
        try{
            fileOut.close();
        }
        catch( IOException ioEx ){
            System.err.println( getName() + "::loadPropertyFile() : " + ioEx);
        }
        
        return props;
    }
//------------------------------------------------------------------------------
    private void writePropertyFile(){
        FileOutputStream propFile = null;
        Properties props = new Properties();
        
        if( !setFolderPropertyFolder() )
            return;        
        
        try{
            propFile = new FileOutputStream( PROPERTY_FILE_LOCATION );
        }
        catch( IOException ioEx ){
            System.err.println( getName() + "::writePropertyFile() : " + ioEx);
            return;
        }
                
        try{
            fillProperties(props);
            props.store( (OutputStream)propFile, "Properties for controling the threadmanager code" );
            propFile.close();
        }
        catch( IOException ioEx ){
            System.err.println( getName() + "::writePropertyFile() : unable to store properties : " + ioEx);
        }
        catch( ClassCastException  castEx ){
            System.err.println( getName() + "::writePropertyFile() : cast problem. Please repor this !: " + castEx);
        }
    }
//------------------------------------------------------------------------------
    private static boolean setFolderPropertyFolder(){
        File folder = null;
        
        try{
            folder = new File(WebGlobal.PROPERTY_FOLDER);
        }
        catch( NullPointerException nullEx ){
            System.err.println( "WebGlobal::setFolderPropertyFolder() : " + nullEx );
            return false;
        }
        
        if( folder.exists() )
            return true;
        else{
            try{
                return folder.mkdir();
            }
            catch( SecurityException secEx ){
                System.err.println( "WebGlobal::setFolderPropertyFolder() : " + secEx );
                return false;
            }
        }
    }
//------------------------------------------------------------------------------    
    
    public void run(){
        /*
         *  We don't call the parent class run() here
         *  because it would simply add ourselves to our list of 
         *  listenners
         *  
         *  super.run();
         */
        
        process();
        
        if( WebGlobal.DEBUG )
            System.err.println( getName() + "::run() : Exiting run()" );        
    }
//------------------------------------------------------------------------------
    private synchronized void process(){
        int state = 0;
        
        while( true ){
            state = getState();
            
            if( state == ThreadEvent.EVENT_STOP )
                break;
            else{
                try{
                    /*
                     *  Release the lock and wait to be notyfied
                     */
                    wait();
                }
                catch( InterruptedException intEx ){
                    if( WebGlobal.DEBUG )
                        System.err.println( getName() + "::run() : " + intEx);                    
                }
            }
        }
    }
//------------------------------------------------------------------------------    
    public int getNbThreads(){
        return m_nbCurrentThreads;
    }
//------------------------------------------------------------------------------   
    public synchronized void addThread(){
        m_nbCurrentThreads++;
        
        if( WebGlobal.DEBUG )
            System.err.println( getName() + "::addThread() : m_nbCurrentThreads = " + m_nbCurrentThreads);

        if( m_nbCurrentThreads > MAX_THREADS ){
            if( WebGlobal.DEBUG )
                System.err.println( getName() + "::addThread() : TO MANY THREADS : " + m_nbCurrentThreads);
        }
    }
//------------------------------------------------------------------------------   
    public synchronized void removeThread(){
        
        if( m_nbCurrentThreads > 0 )
            m_nbCurrentThreads--;
        
        if( WebGlobal.DEBUG )
            System.err.println( getName() + "::removeThread() : m_nbCurrentThreads = " + m_nbCurrentThreads);
        
        notifyAll();
    }    
//------------------------------------------------------------------------------
    public synchronized void canCreateThread(){
        
        while( getNbThreads() >= MAX_THREADS ){
            try{
                /*
                 *  release the lock and wait for removeThread to notify us
                 */
                wait();
            }
            catch( InterruptedException intEx ){
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::canCreateThread() : " + intEx );                
            }
        }
    }
//------------------------------------------------------------------------------
    public void stopThreads(){
        ThreadEvent event = null;
        
        event = new ThreadEvent(this, null, ThreadEvent.EVENT_STOP);
        sendEventAll(event);
    }
//------------------------------------------------------------------------------    
}
