/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.bot.spider.event;

import faust.sacha.web.util.WebGlobal;
import faust.sacha.web.bot.spider.util.EnginGlobal;
import java.util.Vector;

public abstract class ThreadEventManager extends Thread {
    
    private Vector m_listenners;
    protected int m_state;
    
    protected ThreadEventManager( String name ) {
        super(name);
        m_state = ThreadEvent.EVENT_NEW;
        m_listenners = new Vector();
    }
//------------------------------------------------------------------------------
    public void receiveEvent( ThreadEvent event ){
        Object result = null;
        Object source = null;
        int eventType = 0;
        
        result = event.getResult();
        source = event.getSource();
        eventType = event.getEventType();
        
        switch( eventType ){
            case ThreadEvent.EVENT_STOP:
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::receiveEvent : GOT EVENT_STOP  from : " + source.getClass().getName() );            
                
                setState( eventType );
                break;
            case ThreadEvent.EVENT_IS_SITE_FINISH:
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::receiveEvent : GOT EVENT_IS_SITE_FINISH  from : " + source.getClass().getName() );
                
                setState(eventType);
                break;                
            case ThreadEvent.EVENT_SITE_FINISH:
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::receiveEvent : GOT EVENT_SITE_FINISH  from : " + source.getClass().getName() );
                
                setState(eventType);
                break;
            default:
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::receiveEvent : got unreleated eventType : " + eventType + " from : " + source.getClass().getName() );
                
                break;
        }
    }
//------------------------------------------------------------------------------
    public void run(){
        // Register to the ThreadManager
        EnginGlobal.THREAD_MANAGER.addToListeners( (Object)this );
    }
//------------------------------------------------------------------------------
    protected void sendEvent( ThreadEvent event, ThreadEventManager listenner ){
        if( event == null ){
            if( WebGlobal.DEBUG )
                System.err.println(getName() + "::sendEvent : event is null");
            
            return;
        }
        else if( listenner == null ){
            if( WebGlobal.DEBUG )
                System.err.println(getName() + "::sendEvent : listenner is null");
            
            return;
        }
        
        listenner.receiveEvent( event );
    }
//------------------------------------------------------------------------------
    protected void sendEventAll( ThreadEvent event ){
        Vector listenners = null;
        Object destination = null;
        
        synchronized( m_listenners ){
            listenners = (Vector)m_listenners.clone();
        }
        
        for( int i = 0; i < listenners.size(); i++ ){
            destination = (ThreadEventManager)listenners.get(i);
            if( destination == null ){
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::sendEventAll : got null destination at : " + i );

                    continue;
            }

             sendEvent(event, (ThreadEventManager)listenners.get(i) );
        }
    }
//------------------------------------------------------------------------------
    protected void stopAllListenningThreads(){
        ThreadEvent event = null;

        event = new ThreadEvent(this, null, ThreadEvent.EVENT_STOP);
        sendEventAll(event);
    }    
//------------------------------------------------------------------------------
    public void addToListeners( Object listenner ){
        
        if( listenner == null )
            return;
            
        synchronized( m_listenners ){
            m_listenners.add( listenner );
        }
    }
//------------------------------------------------------------------------------
    public synchronized void setState( int state ){
        
        if( WebGlobal.DEBUG )
            System.err.println( getName() + "::setState() : changing state to : " + state );
        
        m_state = state;
        
        /*
         *  Notify all that the state as changed
         */
        notifyAll();
    }
//------------------------------------------------------------------------------
    public int getState(){
        return m_state;
    }    
//------------------------------------------------------------------------------
    
}
