/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.bot.spider.event;

import java.util.EventObject;

public class ThreadEvent extends EventObject {
    public static final int EVENT_NEW =                 0;
    public static final int EVENT_SUCCESS =             1;
    public static final int EVENT_ERROR =               2;
    
    public static final int EVENT_TO_GET_DATA =         3;
    public static final int EVENT_TO_PROCESS_LINKS =    4;
    public static final int EVENT_TO_SET_INFO =         5;
    public static final int EVENT_STOP =                6;
    public static final int EVENT_IS_SITE_FINISH =      7;
    public static final int EVENT_SITE_FINISH =         8;
    public static final int EVENT_FINISH =              9;
    public static final int EVENT_SPIDER_SITE =         10;
    public static final int EVENT_TO_GET_INFO =         11;
    
    
    
    private int m_eventType;
    private Object m_result;
    
    public ThreadEvent( Object source ) {
        super(source);
        m_result = null;
        m_eventType = EVENT_NEW;
    }
//------------------------------------------------------------------------------
    public ThreadEvent( Object source, Object result, int eventType ){
        this(source);
        
        m_result = result;
        m_eventType = eventType;
    }
//------------------------------------------------------------------------------    
    public Object getResult(){
        return m_result;
    }
//------------------------------------------------------------------------------
    public void setResult( Object result ){
        m_result = result;
    }
//------------------------------------------------------------------------------
    public void setEventType( int type ){
        m_eventType = type;
    }
//------------------------------------------------------------------------------
    public int getEventType(){
        return m_eventType;
    }
//------------------------------------------------------------------------------    

}
