/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.bot.spider.event;

import faust.sacha.web.data.URLData;

import faust.sacha.web.util.WebGlobal;

import faust.sacha.web.bot.spider.*;
import faust.sacha.web.bot.spider.data.*;
import faust.sacha.web.bot.spider.event.ProcessBroker;
import faust.sacha.web.bot.spider.util.EnginGlobal;

public abstract class QueueManager extends ThreadEventManager {
    
    protected UrlQInt m_queue;
    protected ProcessBroker m_broker;
    private int m_nbThreads;
    private Object m_nbThreadsMutex;
    
    public QueueManager( String name, UrlQInt queue, ProcessBroker broker ) {
        super(name);
        m_queue = (UrlQInt)queue;
        m_broker = broker;
        m_nbThreads = 0;
        m_nbThreadsMutex = new Object();
    }  
//------------------------------------------------------------------------------    
    public void run(){
        super.run();

        processElements();
        
        if( WebGlobal.DEBUG )
            System.err.println( getName() + "::run() : Exiting run()" );        
    }
//------------------------------------------------------------------------------
    private synchronized void processElements(){
        URLData url = null;
        int state = 0;
        
        while( true ){
            state = getState();
            
            if( (state == ThreadEvent.EVENT_STOP) || (state == ThreadEvent.EVENT_SITE_FINISH) )
                break;

            /*
             *  the call will lock until there is something in the
             *  queue
             */            
            if( WebGlobal.DEBUG )
                System.err.println(getName() + "::processElements() : before get()" );
            
            url = m_queue.get();
            
            if( WebGlobal.DEBUG )
                System.err.println(getName() + "::processElements() : after get()" );
            
            if( url == null ){
                
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::processElements() : got null" );
                
                /*
                 *  Do a quick double check if the state as changed to
                 *  EVENT_SITE_FINISH
                 */
                if( getState() == ThreadEvent.EVENT_SITE_FINISH ){
                    if( WebGlobal.DEBUG )
                        System.err.println( getName() + "::processElements() : got null and EVENT_SITE_FINISH" );
                    
                    break;
                }
                else{
                    /*
                     *  Release the lock ans wait a bit before continuing
                     */
                    try{
                        wait(500);
                    }
                    catch( InterruptedException intEx ){
                        if( WebGlobal.DEBUG )
                            System.err.println( getName() + "::processElements : " + intEx );
                    }
                    continue;
                }
            }
            
            if( WebGlobal.DEBUG )
                System.err.println( getName() + "::run() : got : " + url.getURL() );
            
            process(url);
        }
        
        /*
         *  Indicate to all the thread that
         *  are listenning for us to STOP.
         *  Theses should be FileGetter objects
         */
        if( m_state == ThreadEvent.EVENT_STOP )
            stopAllListenningThreads();        
    }
//------------------------------------------------------------------------------
    protected abstract void process( URLData url );
//------------------------------------------------------------------------------
    protected void addThread(){
        synchronized( m_nbThreadsMutex ){
            m_nbThreads++;
        }
        
        if( WebGlobal.DEBUG )
            System.err.println( getName() + " : m_nbThreads = " + m_nbThreads );
    }
//------------------------------------------------------------------------------
    protected void removeThread(){
        synchronized( m_nbThreadsMutex ){
            m_nbThreads--;
        }
        
        if( WebGlobal.DEBUG )
            System.err.println( getName() + " : m_nbThreads = " + m_nbThreads );
    }
//------------------------------------------------------------------------------
    public int getNbThreads(){
        return m_nbThreads;
    }
//------------------------------------------------------------------------------
    public void receiveEvent( ThreadEvent event ){
        Object result = null;
        Object source = null;
        String sourceName = null;
        int eventType = 0;
        
        result = event.getResult();
        source = event.getSource();
        sourceName = ((ThreadEventManager)source).getName();
        eventType = event.getEventType();
        
        
        switch( eventType ){
            case ThreadEvent.EVENT_FINISH:
                /*
                 *  This is one of our FileGetter thread reporting that he's done
                 */
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::receiveEvent : receive EVEN_FINISH FROM : " + sourceName );
                
                if( result != null ){
                    System.err.println("CODE_ERROR->" + getName() + "::receiveEvent : event type : EVENT_FINISHH : data is not NULL and is type of: " + result.getClass().getName() + " from : " + sourceName );
                    break;
                }
                else if( !(source instanceof FileGetter) ){
                    System.err.println( "CODE ERROR->" + getName() + "::receiveEvent : event type : EVENT_TO_SET_INFO: data type of: " + result.getClass().getName() + " from : " + source.getClass().getName() + " : " + sourceName );
                    break;
                }
                else{
                    removeThread();
                    break;
                }
            default:
                /*
                 *  Pass the event to the parent class
                 */
                super.receiveEvent(event);
                break;
        }
    }
}

