/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.bot.spider.event;

import java.net.MalformedURLException;

import faust.sacha.web.data.*;
import faust.sacha.web.util.*;

import java.util.ArrayList;
import faust.sacha.web.bot.spider.*;
import faust.sacha.web.bot.spider.data.*;

import java.util.*;

public class ProcessBroker extends ThreadEventManager {
    
    private UrlQ m_getDataQueue;
    private Site m_site;
    private ArrayList m_listenners;
    private UrlQInt m_todoQueue;
    private SiteURLProcessor m_urlProcessor;
    private boolean m_processing;
    
    public ProcessBroker(String name, UrlQ getDataQueue, UrlQInt todoQueue, SiteURLProcessor urlProcessor, Site site) {
        super(name);
        m_site = site;
        m_getDataQueue = getDataQueue;
        m_todoQueue = todoQueue;
        m_urlProcessor = urlProcessor;
        m_processing = false;  
    }
//------------------------------------------------------------------------------
    public void run(){
        super.run();
        
        process();
        
        if( WebGlobal.DEBUG )
            System.err.println( getName() + "::run() : Exiting run()" );        
    }
//------------------------------------------------------------------------------
    private synchronized void process(){
        
        int state;
        
        while( true ){
            state = getState();
            
            if( (state == ThreadEvent.EVENT_STOP) || (state == ThreadEvent.EVENT_SITE_FINISH) )
                break;
            
            /*
             *  We release the lock and wait to be notified
             */
            try{
                wait();
            }
            catch( InterruptedException intEx ){
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::run() : " + intEx );
            }
        }
    }
//------------------------------------------------------------------------------
    public void receiveEvent( ThreadEvent event ) {
        Object result = null;
        Object source = null;
        ThreadEvent dataToSend = null;
        int eventType = 0;
        String sourceName = null;
        
        setProcessing(true);
        result = event.getResult();
        source = event.getSource();
        eventType = event.getEventType();
        
        if( source instanceof ThreadEventManager )
            sourceName = ((ThreadEventManager)source).getName();
        
        switch( eventType ){
            case ThreadEvent.EVENT_TO_GET_DATA:
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::receiveEvent : event type : EVENT_TO_GET_DATA : data type of: " + result.getClass().getName() + "from : " + source.getClass().getName() + " : " + sourceName );
                
                if( !(result instanceof URLData) ){
                    System.err.println( "CODE ERROR->" + getName() + "::receiveEvent : event type : EVENT_TO_GET_DATA : data type of : " + result.getClass().getName() + " : " + sourceName );
                    break;
                }
                addToGetData( (URLData)result );
                break;
            case ThreadEvent.EVENT_TO_GET_INFO:
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::receiveEvent : event type : EVENT_TO_GET_INFO : data type of: " + result.getClass().getName() + "from : " + source.getClass().getName() + " : " + sourceName );
                
                if( !(result instanceof URLData) ){
                    System.err.println( "CODE ERROR->" + getName() + "::receiveEvent : event type : EVENT_TO_GET_INFO : data type of : " + result.getClass().getName() + " : " + sourceName );
                    break;
                }
                addToGetInfo( (URLData)result );
                break;
            case ThreadEvent.EVENT_TO_PROCESS_LINKS:
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::receiveEvent : event type : EVENT_TO_PROCESS_LINKS : data type of: " + result.getClass().getName() + "from : " + source.getClass().getName() + " : " + sourceName );
                
                if( result == null ){
                    System.err.println("CODE ERROR->" + getName() + "::receiveEvent : event type : EVENT_TO_PROCESS_LINKS : result is null : from : " + sourceName );
                    break;
                }
                else if( !(result instanceof FileData) ){
                    System.err.println( "CODE ERROR->" + getName() + "::receiveEvent : event type : EVENT_TO_PROCESS_LINKS : data type of: " + result.getClass().getName() + " : " + sourceName);
                    break;
                }
                else{
                    dataToSend = new ThreadEvent(this, result, ThreadEvent.EVENT_TO_PROCESS_LINKS);
                    sendEvent(dataToSend, m_urlProcessor);
                    break;
                }
            case ThreadEvent.EVENT_TO_SET_INFO:
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::receiveEvent : event type : EVENT_TO_SET_INFO: data type of: " + result.getClass().getName() + "from : " + source.getClass().getName() + " : " + sourceName );
                
                if( result == null ){
                    System.err.println( "CODE ERROR->" + getName() + "::receiveEvent : event type : EVENT_TO_SET_INFO: result is null" );
                    break;
                }
                if( !(result instanceof URLData) ){
                    System.err.println( "CODE ERROR->" + getName() + "::receiveEvent : event type : EVENT_TO_SET_INFO: data type of: " + result.getClass().getName() + " from : " + source.getClass().getName() + " : " + sourceName );
                    break;
                }
                else{
                    dataToSend = new ThreadEvent(this, result, ThreadEvent.EVENT_TO_SET_INFO);
                    sendEvent(dataToSend, m_urlProcessor);
                    break;
                }
            case ThreadEvent.EVENT_SITE_FINISH:
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::receiveEvent : event type : EVENT_SITE_FINISH : from : " + source.getClass().getName() + " : " + sourceName );
                
                if( result != null )
                    System.err.println("CODE_ERROR->" + getName() + "::receiveEvent : event type : EVENT_SITE_FINISH : data is not NULL and is type of: " + result.getClass().getName() + " from : " + sourceName );
                
                setState(eventType);
                break;
            default:
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::receiveEvent : UKNOWN EVEVENT TYPE : event type : " + eventType + " from : " + source.getClass().getName() + " : " + sourceName +" data : " + (result == null? "null" : result.toString()) );
                    
                //pass the message to the parent
                super.receiveEvent(event);
                break;
        }
        
        setProcessing(false);
    }
//------------------------------------------------------------------------------
    private void addToGetData( URLData url ){
        URLData cleanURL = null;
        
        //  create a new URLData with clean internals
        try{
            cleanURL = new URLData( (URLInfo)url );
        }
        catch( MalformedURLException urlEx ){
            System.err.println( getName() + "::addToGetData : " + urlEx );
            return;
        }
        
        m_getDataQueue.add( cleanURL );
    }
//------------------------------------------------------------------------------
    private void addToGetInfo( URLData url ){
        URLData newURLInfo = null;
        
        try{
            newURLInfo = new URLData( (URLInfo)url );
        }
        catch( MalformedURLException urlEx ){
            System.err.println( getName() + "::addToGetInfo() : " + urlEx );
            return;
        }
        
        if( !m_site.isURLAlreadyDone( (URLInfo)newURLInfo) ){
            m_site.addURLDone( (URLInfo)newURLInfo );
            
                /*
                 * Checking if the new url is in the same domain as the other one
                 * if not, we just continue to loop and we don't go fetch it
                 */
            if( m_site.getDomain().compareToIgnoreCase(newURLInfo.getHost()) != 0 ){
                if( WebGlobal.DEBUG )
                    System.err.println(getName() + "::addToGetInfo() : " + newURLInfo.getURL() + " not in same domain ");
                
                m_site.addOutsideURL( (URLInfo)newURLInfo );
            }
            else if( newURLInfo.getPort() != url.getPort() ){
                if( WebGlobal.DEBUG )
                    System.err.println(getName() + "::addToGetInfo() : " + newURLInfo.getURL() + " port : " + newURLInfo.getPort() );
                
                m_site.addOutsideURL( (URLInfo)newURLInfo );
            }
            else if( !newURLInfo.getProtocol().equalsIgnoreCase(url.getProtocol()) ){
                if( WebGlobal.DEBUG )
                    System.err.println(getName() + "::addToGetInfo() : " + newURLInfo.getURL() + " protocol : " + newURLInfo.getProtocol() );
                
                m_site.addOutsideURL( (URLInfo)newURLInfo );
            }
            else
                m_todoQueue.add( newURLInfo );
        }
        else{
            if( WebGlobal.DEBUG )
                System.err.println( getName() + "::addToGetInfo() : url already done : " + newURLInfo.getURL() );
        }
    }
//------------------------------------------------------------------------------    
    public synchronized void waitForProcessing(){
        
        if( WebGlobal.DEBUG )
            System.err.println( getName() + "::waitForProcessing() : m_processing : " + m_processing );
        
        while( m_processing == true ){
            try{
               /*
                *   Release the lock and wait to be notified
                */
                wait();
            }
            catch( InterruptedException intEx ){
                if( WebGlobal.DEBUG )
                    System.err.println( getName() + "::waitForProcessing() : " + intEx );
            }
        }
    }
//------------------------------------------------------------------------------
    private synchronized void setProcessing( boolean value ){
        m_processing = value;
        
        /*
         *  Alert all that processing as changed
         *      - waitForProcessing() needs this
         */
        notifyAll();
    }
//------------------------------------------------------------------------------    
}
