/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.bot.spider.event;

import faust.sacha.web.data.URLData;

import faust.sacha.web.bot.spider.event.ProcessBroker;
import faust.sacha.web.bot.spider.data.FileDataGetter;
import faust.sacha.web.bot.spider.data.UrlQ;
import faust.sacha.web.bot.spider.data.UrlQInt;
import faust.sacha.web.bot.spider.util.EnginGlobal;

public class GetDataManager extends QueueManager {
    
    public GetDataManager( String name, UrlQ queue, ProcessBroker broker ) {
        super(name, (UrlQInt)queue,broker);
    }
//------------------------------------------------------------------------------    
    protected void process(URLData url) {
        FileDataGetter fileData = null;
        
        fileData = new FileDataGetter(url, m_broker);
        
        /*
         *  adding ourselves to the filegetter listenners
         *  so it can tell us that it's done
         */
        fileData.addToListeners( (Object)this );
        
        /*
         *  adding the FileInfoGetter to our listenners
         *  so we can send events like EVENT_STOP
         */        
        addToListeners( (Object)fileData );
        
        /*
         *  Adding 1 to our numbers of threads we created
         */        
        addThread();
        
        /*
         *  Wait until the ThreadManager tells us that
         *  we can create a thread
         */
        EnginGlobal.THREAD_MANAGER.canCreateThread();
        
        /*
         *  We can now create the thread
         */        
        fileData.start();
    }
//------------------------------------------------------------------------------
    
}
