/*
** Copyright (C) 2001,2002 Sacha Faust <sacha@severus.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 *  Version : 1.3
 */
package faust.sacha.web.bot.spider.data;

import faust.sacha.web.data.URLData;
import faust.sacha.web.util.WebGlobal;
import java.util.*;

public class UrlQ implements UrlQInt {

    private Stack m_urlList;
    
    public UrlQ() {
        m_urlList = new Stack();
    }
//------------------------------------------------------------------------------
    public synchronized URLData get() {
        URLData retURL = null;
        
        if( m_urlList.isEmpty() ){
            try{
                /*
                 *  Release the lock and wait to be notified
                 *      - add() will notify uss
                 *  We only wait for half a second before we return.
                 */
                wait(500);
            }
            catch( InterruptedException intEx ){
                System.err.println("UrlQ::get() : " + intEx);
            }
        }

        try{
            retURL = (URLData)m_urlList.pop();        
            return retURL;
         }
        catch( EmptyStackException emptyEx ){
            return null;
        }
    }
//------------------------------------------------------------------------------
    public synchronized void add(URLData toAdd) {
        
        if( WebGlobal.DEBUG )
            System.err.println("UrlQ::add() : adding : " + toAdd.getURL());
        
        m_urlList.add(toAdd);
        
        /*
         *  Notify that we just added an element
         *      - get() requires this
         */
        notifyAll();
    }
//------------------------------------------------------------------------------
    public boolean isEmpty() {
        return m_urlList.isEmpty();
    }    
//------------------------------------------------------------------------------

}
